/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.image.processors;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.lang.Rational;
import com.drew.metadata.Metadata;
import com.drew.metadata.StringValue;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectoryBase;
import com.drew.metadata.exif.GpsDirectory;
import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.NoBounds;
import io.annot8.common.data.content.FileContent;
import io.annot8.components.base.processors.AbstractContentProcessor;
import java.io.File;
import java.io.IOException;
import java.util.Date;

@ComponentName(value="EXIF Metadata")
@ComponentDescription(value="Extract EXIF Metadata from images")
public class ExifMetadataProcessor
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    public static final String EXIF_TYPE = "metadata/exif";
    public static final String EXIF_GPS_TYPE = "metadata/exif/gps";

    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withCreatesAnnotations(EXIF_TYPE, NoBounds.class).withCreatesAnnotations(EXIF_GPS_TYPE, NoBounds.class).withProcessesContent(FileContent.class).build();
    }

    public static class Processor
    extends AbstractContentProcessor<FileContent> {
        public Processor() {
            super(FileContent.class);
        }

        public void process(FileContent content) {
            Metadata metadata;
            try {
                metadata = ImageMetadataReader.readMetadata((File)((File)content.getData()));
            }
            catch (ImageProcessingException | IOException e) {
                this.log().error("Failed to read the file for Exif extraction", e);
                return;
            }
            for (ExifDirectoryBase directory : metadata.getDirectoriesOfType(ExifDirectoryBase.class)) {
                if (directory instanceof GpsDirectory) {
                    this.handleGpsDirectory((GpsDirectory)directory, content);
                    continue;
                }
                this.handleDirectory(directory, content);
            }
        }

        private void handleGpsDirectory(GpsDirectory directory, FileContent content) {
            ((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)content.getAnnotations().create().withType(ExifMetadataProcessor.EXIF_GPS_TYPE)).withBounds((Bounds)NoBounds.getInstance()).withProperty("latitude", (Object)directory.getGeoLocation().getLatitude())).withProperty("longitude", (Object)directory.getGeoLocation().getLongitude())).withProperty("date", (Object)directory.getGpsDate().getTime())).save();
        }

        private void handleDirectory(ExifDirectoryBase directory, FileContent content) {
            Annotation.Builder builder = ((Annotation.Builder)content.getAnnotations().create().withType(ExifMetadataProcessor.EXIF_TYPE)).withBounds((Bounds)NoBounds.getInstance());
            for (Tag tag : directory.getTags()) {
                Object object;
                Date date = directory.getDate(tag.getTagType());
                Object value = date == null ? ((object = directory.getObject(tag.getTagType())) instanceof Rational ? Double.valueOf(((Rational)object).doubleValue()) : (object instanceof StringValue ? ((StringValue)object).toString() : object)) : Long.valueOf(date.getTime());
                builder = (Annotation.Builder)builder.withProperty(tag.getTagName(), value);
            }
            builder.save();
        }
    }
}

