/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.db.content;

import io.annot8.common.data.content.ColumnMetadata;
import io.annot8.common.data.content.Row;
import io.annot8.common.data.content.Table;
import io.annot8.common.data.content.TableMetadata;
import io.annot8.components.db.processors.JDBCSettings;
import io.annot8.components.db.utils.DatabaseTableIterator;
import io.annot8.core.exceptions.Annot8RuntimeException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DatabaseTable
implements Table {
    private JDBCSettings settings;
    private TableMetadata tableMetadata;

    public DatabaseTable(TableMetadata metadata, JDBCSettings settings) {
        this.tableMetadata = metadata;
        this.settings = settings;
    }

    public int getColumnCount() {
        return this.tableMetadata.getColumns().size();
    }

    public int getRowCount() {
        return this.tableMetadata.getRowCount();
    }

    public Stream<Row> getRows() {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        try {
            connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM " + this.tableMetadata.getName());
        }
        catch (SQLException e) {
            throw new Annot8RuntimeException("Failed to read database", (Throwable)e);
        }
        DatabaseTableIterator iterator = new DatabaseTableIterator(resultSet, this.tableMetadata);
        Iterable iterable = () -> iterator;
        Stream<Row> stream = StreamSupport.stream(iterable.spliterator(), false);
        stream.onClose(() -> {
            try {
                resultSet.close();
                statement.close();
                connection.close();
            }
            catch (SQLException e) {
                throw new Annot8RuntimeException("Failed to close resources", (Throwable)e);
            }
        });
        return stream;
    }

    public Optional<List<String>> getColumnNames() {
        List names = this.tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
        return Optional.of(names);
    }

    private Connection getConnection() throws SQLException {
        if (this.settings.getUser() != null && !this.settings.getUser().isEmpty()) {
            return DriverManager.getConnection(this.settings.getJdbcUrl(), this.settings.getUser(), this.settings.getPassword());
        }
        return DriverManager.getConnection(this.settings.getJdbcUrl());
    }
}

