/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.base.processors;

import io.annot8.api.components.Processor;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.data.Item;
import io.annot8.common.components.AbstractProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class MultiProcessor
extends AbstractProcessor {
    private Collection<Processor> processors;

    public MultiProcessor() {
        this.processors = new ArrayList<Processor>();
    }

    public MultiProcessor(Processor ... processors) {
        this.processors = Arrays.asList(processors);
    }

    public MultiProcessor(Collection<Processor> processors) {
        this.processors = processors;
    }

    protected void addProcessor(Processor processor) {
        this.processors.add(processor);
    }

    public ProcessorResponse process(Item item) {
        boolean error = false;
        ArrayList exceptions = new ArrayList();
        for (Processor p : this.processors) {
            ProcessorResponse response = p.process(item);
            if (response.getStatus() == ProcessorResponse.Status.OK) continue;
            error = true;
            exceptions.addAll(response.getExceptions());
        }
        if (error) {
            return ProcessorResponse.processingError(exceptions);
        }
        return ProcessorResponse.ok();
    }

    public void close() {
        for (Processor p : this.processors) {
            p.close();
        }
    }
}

