/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.base.processors;

import com.google.common.base.Strings;
import io.annot8.api.settings.Description;
import io.annot8.api.settings.Settings;
import java.util.regex.Pattern;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

public class RegexSettings
implements Settings {
    private final Pattern regex;
    private final int group;
    private final String type;

    @JsonbCreator
    public RegexSettings(@JsonbProperty(value="regex") Pattern regex, @JsonbProperty(value="group") int group, @JsonbProperty(value="type") String type) {
        this.regex = regex;
        this.group = group;
        this.type = type;
    }

    @Description(value="Regular expression pattern to match")
    public Pattern getRegex() {
        return this.regex;
    }

    @Description(value="The group that should be annotated (0 for the whole expression)")
    public int getGroup() {
        return this.group;
    }

    @Description(value="The type of annotation to create")
    public String getType() {
        return this.type;
    }

    public boolean validate() {
        return this.regex != null && this.group >= 0 && !Strings.isNullOrEmpty((String)this.type);
    }
}

