/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.base.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.common.data.utils.SortUtils;
import io.annot8.components.base.processors.AbstractTextProcessor;
import io.annot8.components.stopwords.resources.NoOpStopwords;
import io.annot8.components.stopwords.resources.Stopwords;
import java.util.Map;
import java.util.Set;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

@ComponentName(value="Described Word Token")
@ComponentDescription(value="Finds word tokens matching a pre-defined list, and then looks for additional descriptors preceding these")
@SettingsClass(value=Settings.class)
public class DescribedWordToken
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        Stopwords stopwords = (Stopwords)context.getResource(Stopwords.class).orElse(new NoOpStopwords());
        return new Processor(stopwords, settings.getType(), settings.getRootTokens(), settings.getDescriptors(), settings.isRequireDescriptors(), settings.getProperties());
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withProcessesAnnotations("grammar/wordToken", SpanBounds.class).withProcessesAnnotations("grammar/sentence", SpanBounds.class).withCreatesAnnotations(((Settings)this.getSettings()).getType(), SpanBounds.class).build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private final String type;
        private final Set<String> rootTokens;
        private final Set<String> descriptors;
        private final boolean requireDescriptors;
        private final Map<String, Object> properties;

        @JsonbCreator
        public Settings(@JsonbProperty(value="type") String type, @JsonbProperty(value="rootTokens") Set<String> rootTokens, @JsonbProperty(value="descriptors") Set<String> descriptors, @JsonbProperty(value="requireDescriptors") boolean requireDescriptors, @JsonbProperty(value="properties") Map<String, Object> properties) {
            this.type = type;
            this.rootTokens = rootTokens;
            this.descriptors = descriptors;
            this.requireDescriptors = requireDescriptors;
            this.properties = properties;
        }

        public boolean validate() {
            return this.type != null && !this.type.isEmpty() && this.rootTokens != null && !this.rootTokens.isEmpty() && this.descriptors != null && this.properties != null;
        }

        @Description(value="The type to assign to annotations")
        public String getType() {
            return this.type;
        }

        @Description(value="The set of root tokens to look for")
        public Set<String> getRootTokens() {
            return this.rootTokens;
        }

        @Description(value="The set of allowed descriptors")
        public Set<String> getDescriptors() {
            return this.descriptors;
        }

        @Description(value="Is at least one descriptor required?")
        public boolean isRequireDescriptors() {
            return this.requireDescriptors;
        }

        @Description(value="Additional properties to add to matches")
        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private final String type;
        private final Set<String> rootTokens;
        private final Set<String> descriptors;
        private final boolean requireDescriptors;
        private final Map<String, Object> properties;
        private final Stopwords stopwords;

        public Processor(Stopwords stopwords, String type, Set<String> rootTokens, Set<String> descriptors, boolean requireDescriptors, Map<String, Object> properties) {
            this.stopwords = stopwords;
            this.type = type;
            this.rootTokens = rootTokens;
            this.descriptors = descriptors;
            this.requireDescriptors = requireDescriptors;
            this.properties = properties;
        }

        @Override
        protected void process(Text content) {
            content.getAnnotations().getByBoundsAndType(SpanBounds.class, "grammar/sentence").forEach(sentence -> {
                SpanBounds sentenceSpan = (SpanBounds)sentence.getBounds(SpanBounds.class).get();
                content.getBetween(sentenceSpan.getBegin(), sentenceSpan.getEnd()).filter(a -> "grammar/wordToken".equals(a.getType())).filter(a -> this.rootTokens.stream().anyMatch(s -> s.equalsIgnoreCase(content.getText(a).orElse("")))).forEach(a -> this.findDescriptorsAndCreate(content, sentenceSpan, (Annotation)a));
            });
        }

        protected void findDescriptorsAndCreate(Text content, SpanBounds sentence, Annotation rootWord) {
            SpanBounds rootSpan = (SpanBounds)rootWord.getBounds(SpanBounds.class).get();
            int begin = content.getBetween(sentence.getBegin(), rootSpan.getBegin()).filter(a -> "grammar/wordToken".equals(a.getType())).sorted(SortUtils.SORT_BY_SPANBOUNDS.reversed()).takeWhile(a -> {
                String w = content.getText(a).orElse("");
                return this.stopwords.isStopword(w) || this.descriptors.stream().anyMatch(s -> s.equalsIgnoreCase(w));
            }).sorted(SortUtils.SORT_BY_SPANBOUNDS).dropWhile(a -> this.stopwords.isStopword(content.getText(a).orElse(""))).mapToInt(a -> ((SpanBounds)a.getBounds(SpanBounds.class).get()).getBegin()).min().orElse(rootSpan.getBegin());
            if (this.requireDescriptors && rootSpan.getBegin() == begin) {
                return;
            }
            Annotation.Builder builder = ((Annotation.Builder)content.getAnnotations().create().withType(this.type)).withBounds((Bounds)new SpanBounds(begin, rootSpan.getEnd()));
            for (Map.Entry<String, Object> e : this.properties.entrySet()) {
                builder = (Annotation.Builder)builder.withProperty(e.getKey(), e.getValue());
            }
            builder.save();
        }
    }
}

