/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.base.processors;

import io.annot8.api.components.Processor;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.data.Item;
import io.annot8.common.components.AbstractComponent;

public abstract class AbstractSplitter
extends AbstractComponent
implements Processor {
    public final ProcessorResponse process(Item item) {
        this.metrics().counter("process.called", new String[0]).increment();
        try {
            if (this.acceptsItem(item)) {
                this.metrics().counter("items.accepted", new String[0]).increment();
                boolean discard = this.split(item);
                if (discard) {
                    this.metrics().counter("items.discarded", new String[0]).increment();
                    item.discard();
                }
            }
            return ProcessorResponse.ok();
        }
        catch (Exception e) {
            this.metrics().counter("items.errors", new String[0]).increment();
            return ProcessorResponse.itemError();
        }
    }

    protected boolean acceptsItem(Item item) {
        return false;
    }

    protected abstract boolean split(Item var1);
}

