/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.base.processors;

import com.google.common.base.Strings;
import io.annot8.components.base.processors.AbstractRegex;
import io.annot8.core.context.Context;
import io.annot8.core.exceptions.BadConfigurationException;
import io.annot8.core.exceptions.MissingResourceException;
import io.annot8.core.settings.Settings;
import io.annot8.core.settings.SettingsClass;
import java.util.regex.Pattern;

@SettingsClass(value=RegexSettings.class)
public class Regex
extends AbstractRegex {
    public Regex() {
    }

    public Regex(Pattern pattern, int group, String type) {
        this.pattern = pattern;
        this.group = group;
        this.type = type;
    }

    @Override
    public void configure(Context context) throws BadConfigurationException, MissingResourceException {
        super.configure(context);
        RegexSettings settings = (RegexSettings)context.getSettings(RegexSettings.class).orElseThrow(() -> new BadConfigurationException("Regex settings are required"));
        if (!settings.validate()) {
            throw new BadConfigurationException("Regex settings are invalid");
        }
        this.pattern = settings.getRegex();
        this.group = settings.getGroup();
        this.type = settings.getType();
    }

    public static class RegexSettings
    implements Settings {
        private final Pattern regex;
        private final int group;
        private final String type;

        public RegexSettings(Pattern regex, int group, String type) {
            this.regex = regex;
            this.group = group;
            this.type = type;
        }

        public Pattern getRegex() {
            return this.regex;
        }

        public int getGroup() {
            return this.group;
        }

        public String getType() {
            return this.type;
        }

        public boolean validate() {
            return this.regex != null && this.group >= 0 && !Strings.isNullOrEmpty((String)this.type);
        }
    }
}

