/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.base.processors;

import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.bounds.Bounds;
import io.annot8.core.capabilities.Capabilities;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.Annot8Exception;
import io.annot8.core.exceptions.BadConfigurationException;
import io.annot8.core.exceptions.ProcessingException;
import io.annot8.core.stores.AnnotationStore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AbstractRegex
extends AbstractTextProcessor {
    protected Pattern pattern = null;
    protected int group = 0;
    protected String type = "";

    public AbstractRegex() {
    }

    public AbstractRegex(Pattern pattern, int group, String type) {
        this.pattern = pattern;
        this.group = group;
        this.type = type;
    }

    @Override
    public void buildCapabilities(Capabilities.Builder builder) {
        super.buildCapabilities(builder);
        builder.createsAnnotation(this.type, SpanBounds.class);
    }

    @Override
    protected void process(Item item, Text content) throws Annot8Exception {
        if (this.pattern == null) {
            throw new BadConfigurationException("Parameter 'pattern' must not be null");
        }
        AnnotationStore annotationStore = content.getAnnotations();
        Matcher m = this.pattern.matcher((CharSequence)content.getData());
        while (m.find()) {
            if (!this.acceptMatch(m)) continue;
            try {
                Annotation.Builder builder = annotationStore.create();
                this.addProperties(builder, m);
                ((Annotation.Builder)builder.withType(this.type)).withBounds((Bounds)new SpanBounds(m.start(this.group), m.end(this.group))).save();
            }
            catch (IndexOutOfBoundsException e) {
                throw new ProcessingException("Invalid group", (Throwable)e);
            }
        }
    }

    protected void addProperties(Annotation.Builder builder, Matcher m) {
    }

    protected boolean acceptMatch(Matcher m) {
        return true;
    }
}

