/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.base.processors;

import io.annot8.components.base.processors.AbstractItemProcessor;
import io.annot8.core.context.Context;
import io.annot8.core.data.Content;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.Annot8Exception;
import io.annot8.core.exceptions.BadConfigurationException;
import io.annot8.core.exceptions.MissingResourceException;
import io.annot8.core.settings.Settings;
import io.annot8.core.settings.SettingsClass;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;

@SettingsClass(value=ContentAnnotatorSettings.class)
public abstract class AbstractContentProcessor
extends AbstractItemProcessor {
    private ContentAnnotatorSettings settings;

    @Override
    public void configure(Context context) throws BadConfigurationException, MissingResourceException {
        super.configure(context);
        this.settings = context.getSettings(ContentAnnotatorSettings.class).orElse(null);
        if (this.settings != null && !this.settings.validate()) {
            throw new BadConfigurationException("Invalid content settings");
        }
    }

    @Override
    protected final boolean processItem(Item item) {
        Stream contentToProcess = this.settings == null || this.settings.getContent() == null || this.settings.getContent().isEmpty() ? item.getContents() : this.settings.getContent().stream().flatMap(arg_0 -> ((Item)item).getContentByName(arg_0));
        contentToProcess.filter(this::acceptsContent).forEach(c -> {
            try {
                this.metrics().counter("content.accepted", new String[0]).increment();
                this.processContent(item, (Content<?>)c);
            }
            catch (Annot8Exception e) {
                this.metrics().counter("content.errors", new String[0]).increment();
                this.log().warn("Unable to process content {}", (Object)c.getName(), (Object)e);
            }
        });
        return true;
    }

    protected boolean acceptsContent(Content<?> content) {
        return true;
    }

    protected abstract void processContent(Item var1, Content<?> var2) throws Annot8Exception;

    public static class ContentAnnotatorSettings
    implements Settings {
        private final Set<String> content;

        public ContentAnnotatorSettings(Set<String> content) {
            this.content = content;
        }

        public Set<String> getContent() {
            return this.content == null ? Collections.emptySet() : this.content;
        }

        public boolean validate() {
            return true;
        }
    }
}

