/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.base.components;

import io.annot8.components.monitor.resources.Logging;
import io.annot8.components.monitor.resources.Metering;
import io.annot8.components.monitor.resources.metering.Metrics;
import io.annot8.components.monitor.resources.metering.NoOpMetrics;
import io.annot8.core.components.Annot8Component;
import io.annot8.core.context.Context;
import io.annot8.core.exceptions.BadConfigurationException;
import io.annot8.core.exceptions.MissingResourceException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public abstract class AbstractComponent
implements Annot8Component {
    private Logger logger;
    private Metrics metrics;

    public void configure(Context context) throws BadConfigurationException, MissingResourceException {
        super.configure(context);
        Optional logging = context.getResource(Logging.class);
        if (logging.isPresent()) {
            this.logger = ((Logging)logging.get()).getLogger(this.getClass());
        } else {
            this.createNopLogger();
        }
        Optional metering = context.getResource(Metering.class);
        if (metering.isPresent()) {
            this.metrics = ((Metering)metering.get()).getMetrics(this.getClass());
        } else {
            this.createNopMetrics();
        }
        this.metrics().counter("configure.called", new String[0]).increment();
    }

    protected Logger log() {
        if (this.logger == null) {
            this.createNopLogger();
        }
        return this.logger;
    }

    protected Metrics metrics() {
        if (this.metrics == null) {
            this.createNopMetrics();
        }
        return this.metrics;
    }

    private void createNopLogger() {
        this.logger = NOPLogger.NOP_LOGGER;
    }

    private void createNopMetrics() {
        this.metrics = NoOpMetrics.instance();
    }
}

