/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.utils.capabilities;

import io.annot8.core.capabilities.AnnotationCapability;
import io.annot8.core.capabilities.Capabilities;
import io.annot8.core.capabilities.ContentCapability;
import io.annot8.core.capabilities.GroupCapability;
import io.annot8.core.capabilities.ResourceCapability;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class MergedCapabilities
implements Capabilities {
    private final Capabilities[] capabilities;

    public MergedCapabilities(Capabilities ... capabilities) {
        this.capabilities = capabilities;
    }

    public Stream<AnnotationCapability> getProcessedAnnotations() {
        return this.merge(Capabilities::getProcessedAnnotations);
    }

    public Stream<AnnotationCapability> getCreatedAnnotations() {
        return this.merge(Capabilities::getCreatedAnnotations);
    }

    public Stream<AnnotationCapability> getDeletedAnnotations() {
        return this.merge(Capabilities::getDeletedAnnotations);
    }

    public Stream<GroupCapability> getProcessedGroups() {
        return this.merge(Capabilities::getProcessedGroups);
    }

    public Stream<GroupCapability> getCreatedGroups() {
        return this.merge(Capabilities::getCreatedGroups);
    }

    public Stream<GroupCapability> getDeletedGroups() {
        return this.merge(Capabilities::getDeletedGroups);
    }

    public Stream<ContentCapability> getCreatedContent() {
        return this.merge(Capabilities::getCreatedContent);
    }

    public Stream<ContentCapability> getDeletedContent() {
        return this.merge(Capabilities::getDeletedContent);
    }

    public Stream<ContentCapability> getProcessedContent() {
        return this.merge(Capabilities::getProcessedContent);
    }

    public Stream<ResourceCapability> getUsedResources() {
        return this.merge(Capabilities::getUsedResources);
    }

    private <T> Stream<T> merge(Function<Capabilities, Stream<T>> extractor) {
        if (this.capabilities == null || this.capabilities.length == 0) {
            return Stream.empty();
        }
        return Arrays.stream(this.capabilities).filter(Objects::nonNull).flatMap(extractor).filter(Objects::nonNull).distinct();
    }
}

