/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.serialization;

import io.annot8.api.components.Annot8ComponentDescriptor;
import java.lang.reflect.Type;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbException;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;

public class Annot8ComponentDescriptorDeserializer
implements JsonbDeserializer<Annot8ComponentDescriptor> {
    private static final Jsonb jb = JsonbBuilder.create();

    public Annot8ComponentDescriptor deserialize(JsonParser parser, DeserializationContext ctx, Type type) {
        Annot8ComponentDescriptor desc = null;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            if (event != JsonParser.Event.KEY_NAME) continue;
            String className = parser.getString();
            parser.next();
            try {
                desc = (Annot8ComponentDescriptor)jb.fromJson(parser.getObject().toString(), Class.forName(className).asSubclass(Annot8ComponentDescriptor.class));
            }
            catch (ClassNotFoundException e) {
                throw new JsonbException("Deserialization failed - could not find class " + className, (Throwable)e);
            }
        }
        return desc;
    }
}

