/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.listeners;

import io.annot8.common.implementations.listeners.Deregister;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiConsumer;

public class Listeners<L, E> {
    private final BiConsumer<L, E> publish;
    private Set<L> set = null;

    public Listeners(BiConsumer<L, E> publish) {
        this.publish = publish;
    }

    public Deregister register(L listener) {
        if (this.publish == null) {
            return () -> {};
        }
        Objects.requireNonNull(listener);
        if (this.set == null) {
            this.set = new CopyOnWriteArraySet<L>();
        }
        this.set.add(listener);
        return () -> this.deregister(listener);
    }

    public void deregister(L listener) {
        if (this.set != null) {
            this.set.remove(listener);
        }
    }

    public void fire(E event) {
        if (this.set != null && event != null && this.publish != null) {
            this.set.forEach(l -> this.publish.accept(l, event));
        }
    }

    public void clear() {
        if (this.set != null) {
            this.set.clear();
        }
    }
}

