/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.factories;

import io.annot8.common.implementations.data.BaseItemFactory;
import io.annot8.common.implementations.listeners.Deregister;
import io.annot8.common.implementations.listeners.Listenable;
import io.annot8.common.implementations.listeners.Listeners;
import io.annot8.core.data.BaseItem;
import java.util.function.Consumer;

public class NotifyingBaseItemFactory
implements BaseItemFactory,
Listenable<Consumer<BaseItem>> {
    private final Listeners<Consumer<BaseItem>, BaseItem> listeners = new Listeners<Consumer, BaseItem>(Consumer::accept);
    private final BaseItemFactory itemFactory;

    public NotifyingBaseItemFactory(BaseItemFactory itemFactory) {
        this.itemFactory = itemFactory;
    }

    @Override
    public Deregister register(Consumer<BaseItem> consumer) {
        return this.listeners.register(consumer);
    }

    @Override
    public void deregister(Consumer<BaseItem> consumer) {
        this.listeners.deregister(consumer);
    }

    @Override
    public BaseItem create() {
        BaseItem item = this.itemFactory.create();
        this.listeners.fire(item);
        return item;
    }

    @Override
    public BaseItem create(BaseItem parent) {
        BaseItem item = this.itemFactory.create(parent);
        this.listeners.fire(item);
        return item;
    }
}

