/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.context;

import io.annot8.core.components.Resource;
import io.annot8.core.context.Context;
import io.annot8.core.settings.Settings;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class MergedContext
implements Context {
    private final List<Context> contexts;

    public MergedContext(Context ... contexts) {
        this.contexts = Arrays.asList(contexts);
    }

    public Stream<Settings> getSettings() {
        return this.contexts.stream().flatMap(Context::getSettings);
    }

    public <T extends Settings> Optional<T> getSettings(Class<T> clazz) {
        return this.contexts.stream().map(c -> c.getSettings(clazz)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public <T extends Resource> Optional<T> getResource(String key, Class<T> clazz) {
        return this.contexts.stream().map(c -> c.getResource(key, clazz)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Stream<String> getResourceKeys() {
        return this.contexts.stream().flatMap(Context::getResourceKeys);
    }

    public Stream<String> getResourceKeys(Class<? extends Resource> clazz) {
        return this.contexts.stream().flatMap(c -> c.getResourceKeys(clazz));
    }

    public <T extends Resource> Optional<T> getResource(Class<T> clazz) {
        return this.contexts.stream().map(c -> c.getResource(clazz)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public <T extends Resource> Stream<T> getResources(Class<T> clazz) {
        return this.contexts.stream().flatMap(c -> c.getResources(clazz));
    }
}

