/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.content;

import io.annot8.common.implementations.properties.MapImmutableProperties;
import io.annot8.core.data.Content;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.properties.ImmutableProperties;
import io.annot8.core.properties.Properties;
import java.util.UUID;
import java.util.function.Supplier;

public abstract class AbstractContentBuilder<D, C extends Content<D>>
implements Content.Builder<C, D> {
    private final ImmutableProperties.Builder properties = new MapImmutableProperties.Builder();
    private String name;
    private String id;
    private Supplier<D> data;

    public Content.Builder<C, D> withId(String id) {
        this.id = id;
        return this;
    }

    public Content.Builder<C, D> withName(String name) {
        this.name = name;
        return this;
    }

    public Content.Builder<C, D> withData(Supplier<D> data) {
        this.data = data;
        return this;
    }

    public Content.Builder<C, D> from(C from) {
        return this;
    }

    public Content.Builder<C, D> withProperty(String key, Object value) {
        this.properties.withProperty(key, value);
        return this;
    }

    public Content.Builder<C, D> withProperties(Properties properties) {
        this.properties.withProperties(properties);
        return this;
    }

    public Content.Builder<C, D> withoutProperty(String key, Object value) {
        this.properties.withoutProperty(key, value);
        return this;
    }

    public Content.Builder<C, D> withoutProperty(String key) {
        this.properties.withoutProperty(key);
        return this;
    }

    public C save() throws IncompleteException {
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }
        if (this.name == null) {
            throw new IncompleteException("Name is required");
        }
        if (this.data == null) {
            throw new IncompleteException("Data supplier is required");
        }
        return this.create(this.id, this.name, (ImmutableProperties)this.properties.save(), this.data);
    }

    protected abstract C create(String var1, String var2, ImmutableProperties var3, Supplier<D> var4);
}

