/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.configuration;

import io.annot8.common.implementations.configuration.ComponentHolder;
import io.annot8.common.implementations.configuration.ResourcesHolder;
import io.annot8.common.implementations.context.MergedContext;
import io.annot8.common.implementations.context.SimpleContext;
import io.annot8.core.components.Annot8Component;
import io.annot8.core.components.Resource;
import io.annot8.core.context.Context;
import io.annot8.core.settings.Settings;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentConfigurer.class);
    private final Context globalContext;
    private Map<String, Resource> resources = new HashMap<String, Resource>();

    public ComponentConfigurer(Context context) {
        this.globalContext = context;
        this.globalContext.getResourceKeys().forEach(k -> this.globalContext.getResource(k, Resource.class).ifPresent(r -> this.resources.put((String)k, (Resource)r)));
    }

    public Map<String, Resource> configureResources(ResourcesHolder resourcesHolder) {
        resourcesHolder.getResourcesToConfiguration().forEach((resource, settings) -> {
            if (this.configureComponent((Annot8Component)resource, (Collection<Settings>)settings)) {
                String id = resourcesHolder.getId((Resource)resource);
                this.resources.put(id, (Resource)resource);
            }
        });
        return this.getResources();
    }

    public Map<String, Resource> getResources() {
        return this.resources;
    }

    public <T extends Annot8Component> List<T> configureComponents(ComponentHolder<T> holder) {
        return this.configureAllComponents(holder.getComponentToConfiguration());
    }

    protected <T extends Annot8Component> List<T> configureAllComponents(Map<T, Collection<Settings>> componentToConfiguration) {
        return componentToConfiguration.entrySet().stream().filter(e -> this.configureComponent((Annot8Component)e.getKey(), (Collection)e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public <T extends Annot8Component> boolean configureComponent(T component, Collection<Settings> settings) {
        try {
            SimpleContext componentContext = new SimpleContext(settings, this.resources);
            MergedContext context = new MergedContext(this.globalContext, componentContext);
            component.configure((Context)context);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to configure component {}", (Object)component.getClass().getName(), (Object)e);
            return false;
        }
    }
}

