/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.capabilities;

import io.annot8.core.capabilities.AnnotationCapability;
import io.annot8.core.capabilities.Capabilities;
import io.annot8.core.capabilities.ContentCapability;
import io.annot8.core.capabilities.GroupCapability;
import io.annot8.core.capabilities.ResourceCapability;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public class SetCapabilities
implements Capabilities {
    private final Set<AnnotationCapability> processedAnnotations;
    private final Set<AnnotationCapability> createdAnnotations;
    private final Set<AnnotationCapability> deletedAnnotations;
    private final Set<GroupCapability> processedGroups;
    private final Set<GroupCapability> createdGroups;
    private final Set<GroupCapability> deletedGroups;
    private final Set<ContentCapability> processedContent;
    private final Set<ContentCapability> createdContent;
    private final Set<ContentCapability> deletedContent;
    private final Set<ResourceCapability> usedResources;

    public SetCapabilities(Set<AnnotationCapability> processedAnnotations, Set<AnnotationCapability> createdAnnotations, Set<AnnotationCapability> deletedAnnotations, Set<GroupCapability> processedGroups, Set<GroupCapability> createdGroups, Set<GroupCapability> deletedGroups, Set<ContentCapability> processedContent, Set<ContentCapability> createdContent, Set<ContentCapability> deletedContent, Set<ResourceCapability> usedResources) {
        this.processedAnnotations = processedAnnotations;
        this.createdAnnotations = createdAnnotations;
        this.deletedAnnotations = deletedAnnotations;
        this.processedGroups = processedGroups;
        this.createdGroups = createdGroups;
        this.deletedGroups = deletedGroups;
        this.processedContent = processedContent;
        this.createdContent = createdContent;
        this.deletedContent = deletedContent;
        this.usedResources = usedResources;
    }

    public Stream<AnnotationCapability> getProcessedAnnotations() {
        return this.processedAnnotations.stream();
    }

    public Stream<AnnotationCapability> getCreatedAnnotations() {
        return this.createdAnnotations.stream();
    }

    public Stream<AnnotationCapability> getDeletedAnnotations() {
        return this.deletedAnnotations.stream();
    }

    public Stream<GroupCapability> getProcessedGroups() {
        return this.processedGroups.stream();
    }

    public Stream<GroupCapability> getCreatedGroups() {
        return this.createdGroups.stream();
    }

    public Stream<GroupCapability> getDeletedGroups() {
        return this.deletedGroups.stream();
    }

    public Stream<ContentCapability> getCreatedContent() {
        return this.createdContent.stream();
    }

    public Stream<ContentCapability> getDeletedContent() {
        return this.deletedContent.stream();
    }

    public Stream<ContentCapability> getProcessedContent() {
        return this.processedContent.stream();
    }

    public Stream<ResourceCapability> getUsedResources() {
        return this.usedResources.stream();
    }

    public static class Builder
    implements Capabilities.Builder {
        private final Set<AnnotationCapability> processedAnnotations = new HashSet<AnnotationCapability>();
        private final Set<AnnotationCapability> createdAnnotations = new HashSet<AnnotationCapability>();
        private final Set<AnnotationCapability> deletedAnnotations = new HashSet<AnnotationCapability>();
        private final Set<GroupCapability> processedGroups = new HashSet<GroupCapability>();
        private final Set<GroupCapability> createdGroups = new HashSet<GroupCapability>();
        private final Set<GroupCapability> deletedGroups = new HashSet<GroupCapability>();
        private final Set<ContentCapability> processedContent = new HashSet<ContentCapability>();
        private final Set<ContentCapability> createdContent = new HashSet<ContentCapability>();
        private final Set<ContentCapability> deletedContent = new HashSet<ContentCapability>();
        private final Set<ResourceCapability> usedResources = new HashSet<ResourceCapability>();

        public Capabilities.Builder processesAnnotation(AnnotationCapability capability) {
            this.processedAnnotations.add(capability);
            return this;
        }

        public Capabilities.Builder createsAnnotation(AnnotationCapability capability) {
            this.createdAnnotations.add(capability);
            return this;
        }

        public Capabilities.Builder deletesAnnotation(AnnotationCapability capability) {
            this.deletedAnnotations.add(capability);
            return this;
        }

        public Capabilities.Builder processesGroup(GroupCapability capability) {
            this.processedGroups.add(capability);
            return this;
        }

        public Capabilities.Builder createsGroup(GroupCapability capability) {
            this.createdGroups.add(capability);
            return this;
        }

        public Capabilities.Builder deletesGroup(GroupCapability capability) {
            this.deletedGroups.add(capability);
            return this;
        }

        public Capabilities.Builder processesContent(ContentCapability capability) {
            this.processedContent.add(capability);
            return this;
        }

        public Capabilities.Builder createsContent(ContentCapability capability) {
            this.createdContent.add(capability);
            return this;
        }

        public Capabilities.Builder deletesContent(ContentCapability capability) {
            this.deletedContent.add(capability);
            return this;
        }

        public Capabilities.Builder usesResource(ResourceCapability capability) {
            this.usedResources.add(capability);
            return this;
        }

        public Capabilities save() {
            return new SetCapabilities(Collections.unmodifiableSet(this.processedAnnotations), Collections.unmodifiableSet(this.createdAnnotations), Collections.unmodifiableSet(this.deletedAnnotations), Collections.unmodifiableSet(this.processedGroups), Collections.unmodifiableSet(this.createdGroups), Collections.unmodifiableSet(this.deletedGroups), Collections.unmodifiableSet(this.processedContent), Collections.unmodifiableSet(this.createdContent), Collections.unmodifiableSet(this.deletedContent), Collections.unmodifiableSet(this.usedResources));
        }
    }
}

