/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.capabilities;

import io.annot8.common.implementations.capabilities.AnnotationBasedCapabilities;
import io.annot8.core.capabilities.Capabilities;
import io.annot8.core.components.Annot8Component;
import java.util.function.Supplier;

public class CapabilitiesCompiler {
    private final Supplier<Capabilities.Builder> builderSupplier;

    public CapabilitiesCompiler(Supplier<Capabilities.Builder> builderSupplier) {
        this.builderSupplier = builderSupplier;
    }

    public Capabilities compile(Annot8Component component) {
        Capabilities.Builder builder = this.builderSupplier.get();
        this.addAnnotatedCapabilities(builder, component.getClass());
        this.addGetCapabilities(builder, component);
        return builder.save();
    }

    protected void addGetCapabilities(Capabilities.Builder builder, Annot8Component component) {
        component.buildCapabilities(builder);
    }

    protected void addAnnotatedCapabilities(Capabilities.Builder builder, Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            this.addAnnotatedCapabilities(builder, superclass);
        }
        AnnotationBasedCapabilities capabilities = new AnnotationBasedCapabilities(clazz);
        builder.merge((Capabilities)capabilities);
    }
}

