/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.registries;

import io.annot8.core.components.Annot8Component;
import io.annot8.core.components.Processor;
import io.annot8.core.components.Source;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class Annot8ComponentRegistry {
    private final Set<Class<? extends Annot8Component>> classes;

    public Annot8ComponentRegistry(Set<Class<? extends Annot8Component>> classes) {
        this.classes = Collections.unmodifiableSet(classes);
    }

    public Stream<Class<? extends Source>> getSources() {
        return this.classes.stream().filter(Source.class::isAssignableFrom).map(c -> c.asSubclass(Source.class));
    }

    public Stream<Class<? extends Processor>> getProcessors() {
        return this.classes.stream().filter(Processor.class::isAssignableFrom).map(c -> c.asSubclass(Processor.class));
    }

    public Optional<Class<? extends Processor>> getProcessor(String klass) {
        return this.getProcessors().filter(c -> c.getName().equals(klass)).findFirst();
    }

    public Optional<Class<? extends Source>> getSource(String klass) {
        return this.getSources().filter(c -> c.getName().equals(klass)).findFirst();
    }

    public <T extends Annot8Component> Optional<Class<? extends T>> getComponent(String klass, Class<T> componentType) {
        return this.classes.stream().filter(componentType::isAssignableFrom).filter(c -> c.getName().equals(klass)).findFirst().map(c -> c.asSubclass(componentType));
    }
}

