/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.pipelines.management;

import io.annot8.common.implementations.pipelines.Pipeline;
import io.annot8.common.implementations.pipelines.PipelineBuilder;
import io.annot8.common.implementations.pipelines.configuration.ComponentConfiguration;
import io.annot8.common.implementations.pipelines.configuration.PipelineConfiguration;
import io.annot8.common.implementations.pipelines.configuration.TypedComponentConfiguration;
import io.annot8.common.implementations.pipelines.management.PipelineFactory;
import io.annot8.common.implementations.registries.Annot8ComponentRegistry;
import io.annot8.core.components.Annot8Component;
import io.annot8.core.components.Processor;
import io.annot8.core.components.Resource;
import io.annot8.core.components.Source;
import io.annot8.core.exceptions.Annot8Exception;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.settings.Settings;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePipelineFactory
implements PipelineFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplePipelineFactory.class);
    private final Supplier<PipelineBuilder> builderFactory;
    private final Annot8ComponentRegistry componentRegistry;

    public SimplePipelineFactory(Supplier<PipelineBuilder> builderFactory, Annot8ComponentRegistry componentRegistry) {
        this.builderFactory = builderFactory;
        this.componentRegistry = componentRegistry;
    }

    @Override
    public Pipeline create(PipelineConfiguration pipelineConfiguration) throws IncompleteException {
        return this.createPipeline(pipelineConfiguration);
    }

    private Pipeline createPipeline(PipelineConfiguration configuration) throws IncompleteException {
        PipelineBuilder pipelineBuilder = this.builderFactory.get();
        configuration.getSources().forEach(s -> this.addComponentToBuilder((Class)Source.class, (ComponentConfiguration)s, (i, c) -> pipelineBuilder.addSource((Source)i, (Collection<Settings>)c)));
        configuration.getProcessors().forEach(s -> this.addComponentToBuilder((Class)Processor.class, (ComponentConfiguration)s, (i, c) -> pipelineBuilder.addProcessor((Processor)i, (Collection<Settings>)c)));
        configuration.getResources().forEach(s -> this.addComponentToBuilder((Class)Resource.class, (ComponentConfiguration)s, (i, c) -> pipelineBuilder.addResource(s.getName(), (Resource)i, (Collection<Settings>)c)));
        return pipelineBuilder.build();
    }

    private <T extends Annot8Component> void addComponentToBuilder(Class<T> clazz, ComponentConfiguration config, BiConsumer<T, Collection<Settings>> consumer) {
        try {
            TypedComponentConfiguration<T> tcc = this.validateComponent(config, clazz);
            Annot8Component s = (Annot8Component)this.createInstance(tcc.getComponentClass());
            consumer.accept(s, tcc.getSettings());
        }
        catch (Annot8Exception e) {
            LOGGER.warn(e.getMessage());
            LOGGER.debug("Exception is:", (Throwable)e);
        }
    }

    private <T extends Annot8Component> TypedComponentConfiguration<T> validateComponent(ComponentConfiguration config, Class<T> componentType) throws Annot8Exception {
        try {
            Optional<Class<T>> optional = this.componentRegistry.getComponent(config.getComponent(), componentType);
            Class<T> componentClass = optional.get();
            return new TypedComponentConfiguration<T>(componentClass, config.getSettings());
        }
        catch (Exception e) {
            throw new Annot8Exception("Could not find class implementation for component name " + config.getComponent(), (Throwable)e);
        }
    }

    private <T> T createInstance(Class<T> clazz) throws Annot8Exception {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new Annot8Exception("Could not create instance of component " + clazz.getName(), (Throwable)e);
        }
    }
}

