/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.pipelines;

import io.annot8.common.implementations.context.SimpleContext;
import io.annot8.common.implementations.factories.ItemCreator;
import io.annot8.common.implementations.pipelines.ItemQueue;
import io.annot8.common.implementations.pipelines.Pipeline;
import io.annot8.common.implementations.pipelines.PipelineBuilder;
import io.annot8.common.implementations.pipelines.SimpleItemQueue;
import io.annot8.common.implementations.pipelines.SimplePipeline;
import io.annot8.core.components.Annot8Component;
import io.annot8.core.components.Processor;
import io.annot8.core.components.Resource;
import io.annot8.core.components.Source;
import io.annot8.core.context.Context;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.settings.Settings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePipelineBuilder
implements PipelineBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplePipeline.class);
    protected ItemQueue itemQueue;
    protected ItemCreator itemCreator;
    private final Map<Source, Collection<Settings>> sourcesToConfiguration = new LinkedHashMap<Source, Collection<Settings>>();
    private final Map<Processor, Collection<Settings>> processorToConfiguration = new LinkedHashMap<Processor, Collection<Settings>>();
    private final Map<Resource, Collection<Settings>> resourcesToConfiguration = new LinkedHashMap<Resource, Collection<Settings>>();
    private final Map<Resource, String> resourcesToId = new HashMap<Resource, String>();

    @Override
    public PipelineBuilder withItemQueue(ItemQueue itemQueue) {
        this.itemQueue = itemQueue;
        return this;
    }

    @Override
    public PipelineBuilder withItemCreator(ItemCreator itemCreator) {
        this.itemCreator = itemCreator;
        return this;
    }

    @Override
    public PipelineBuilder addResource(String id, Resource resource, Collection<Settings> configuration) {
        this.resourcesToConfiguration.put(resource, this.nonNullCollection(configuration));
        this.resourcesToId.put(resource, id);
        return this;
    }

    @Override
    public PipelineBuilder addSource(Source source, Collection<Settings> configuration) {
        this.sourcesToConfiguration.put(source, this.nonNullCollection(configuration));
        return this;
    }

    @Override
    public PipelineBuilder addProcessor(Processor processor, Collection<Settings> configuration) {
        this.processorToConfiguration.put(processor, this.nonNullCollection(configuration));
        return this;
    }

    @Override
    public Pipeline build() throws IncompleteException {
        if (this.itemCreator == null) {
            throw new IncompleteException("No item creator specified");
        }
        if (this.itemQueue == null) {
            LOGGER.warn("No item queue specified, (using SimpleItemQueue as an basic implementation)");
            this.itemQueue = new SimpleItemQueue();
        }
        HashMap<String, Resource> configuredResources = new HashMap<String, Resource>();
        this.resourcesToConfiguration.forEach((resource, settings) -> {
            if (this.configureComponent((Map<String, Resource>)configuredResources, (Annot8Component)resource, (Collection<Settings>)settings)) {
                String id = this.resourcesToId.get(resource);
                configuredResources.put(id, (Resource)resource);
            }
        });
        List<Source> configuredSources = this.configureAllComponents(configuredResources, this.sourcesToConfiguration);
        List<Processor> configurePipelines = this.configureAllComponents(configuredResources, this.processorToConfiguration);
        return new SimplePipeline(this.itemCreator, this.itemQueue, configuredResources, configuredSources, configurePipelines);
    }

    protected <T extends Annot8Component> List<T> configureAllComponents(Map<String, Resource> configuredResources, Map<T, Collection<Settings>> componentToConfiguration) {
        return componentToConfiguration.entrySet().stream().filter(e -> this.configureComponent(configuredResources, (Annot8Component)e.getKey(), (Collection)e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    protected boolean configureComponent(Map<String, Resource> configuredResources, Annot8Component component, Collection<Settings> configuration) {
        try {
            SimpleContext context = new SimpleContext(configuration, configuredResources);
            component.configure((Context)context);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to configure component {}", (Object)component.getClass().getName(), (Object)e);
            return false;
        }
    }

    private Collection<Settings> nonNullCollection(Collection<Settings> configuration) {
        return configuration == null ? Collections.emptySet() : configuration;
    }
}

