/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.factories;

import io.annot8.common.implementations.factories.ItemCreator;
import io.annot8.common.implementations.factories.SimpleItemFactory;
import io.annot8.core.data.Item;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class NotifyingItemFactory
extends SimpleItemFactory {
    private final Set<Consumer<Item>> listeners = new HashSet<Consumer<Item>>();

    public NotifyingItemFactory(ItemCreator creator) {
        super(creator);
    }

    public void registerListener(Consumer<Item> consumer) {
        this.listeners.add(consumer);
    }

    public void unregisterListener(Consumer<Item> consumer) {
        this.listeners.remove(consumer);
    }

    @Override
    public Item create() {
        Item item = super.create();
        this.notifyListeners(item);
        return item;
    }

    @Override
    public Item create(Item parent) {
        Item item = super.create(parent);
        this.notifyListeners(item);
        return item;
    }

    private void notifyListeners(Item item) {
        this.listeners.forEach(l -> l.accept(item));
    }
}

