/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.context;

import io.annot8.core.components.Resource;
import io.annot8.core.context.Context;
import io.annot8.core.settings.Settings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class SimpleContext
implements Context {
    private final Map<String, Resource> resources = new HashMap<String, Resource>();
    private final Collection<Settings> settings;

    public SimpleContext() {
        this(null, null);
    }

    public SimpleContext(Collection<Settings> settings) {
        this(settings, null);
    }

    public SimpleContext(Map<String, Resource> resources) {
        this(null, resources);
    }

    public SimpleContext(Collection<Settings> settings, Map<String, Resource> resources) {
        this.settings = settings;
        if (resources != null) {
            this.resources.putAll(resources);
        }
    }

    public void addResource(String key, Resource resource) {
        this.resources.put(key, resource);
    }

    public Stream<Settings> getSettings() {
        return this.settings != null ? this.settings.stream() : Stream.empty();
    }

    public <T extends Resource> Optional<T> getResource(String s, Class<T> aClass) {
        Resource r = this.resources.get(s);
        if (r == null || !aClass.isAssignableFrom(r.getClass())) {
            return Optional.empty();
        }
        return Optional.of((Resource)aClass.cast(r));
    }

    public Stream<String> getResourceKeys() {
        return this.resources.keySet().stream();
    }

    public <T extends Resource> Stream<T> getResources(Class<T> aClass) {
        return this.resources.values().stream().filter(r -> aClass.isAssignableFrom(r.getClass())).map(aClass::cast);
    }

    public String toString() {
        return this.getClass().getName() + " [settings=" + this.settings + ", resources=" + this.resources + "]";
    }

    public int hashCode() {
        return Objects.hash(this.settings, this.resources);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Context)) {
            return false;
        }
        Context c = (Context)obj;
        HashMap resourceMap = new HashMap();
        c.getResourceKeys().forEach(s -> {
            Optional r = c.getResource(s, Resource.class);
            r.ifPresent(resource -> resourceMap.put(s, resource));
        });
        return Objects.equals(c.getSettings(), this.getSettings()) && Objects.equals(resourceMap, this.resources);
    }
}

