/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.capabilities;

import com.google.common.collect.ImmutableSetMultimap;
import io.annot8.core.settings.EmptySettings;
import io.annot8.core.settings.Settings;
import io.annot8.core.settings.SettingsClass;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SettingsCompiler {
    public Map<Class<?>, Collection<Class<? extends Settings>>> compile(Class<?> component) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        this.addAnnotatedSettings(builder, component);
        return builder.build().asMap();
    }

    public Set<Class<? extends Settings>> compileAsSet(Class<?> component) {
        Collection<Collection<Class<? extends Settings>>> values = this.compile(component).values();
        if (values.isEmpty()) {
            return Collections.emptySet();
        }
        return values.stream().flatMap(s -> s.stream()).collect(Collectors.toSet());
    }

    protected void addAnnotatedSettings(ImmutableSetMultimap.Builder<Class<?>, Class<? extends Settings>> classes, Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            this.addAnnotatedSettings(classes, superclass);
        }
        SettingsClass[] annotations = (SettingsClass[])clazz.getAnnotationsByType(SettingsClass.class);
        Arrays.stream(annotations).filter(a -> !Settings.class.equals((Object)a.value()) && !EmptySettings.class.equals((Object)a.value())).forEach(a -> classes.put((Object)clazz, (Object)a.value()));
    }
}

