/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.implementations.capabilities;

import io.annot8.core.capabilities.AnnotationCapability;
import io.annot8.core.capabilities.Capabilities;
import io.annot8.core.capabilities.ContentCapability;
import io.annot8.core.capabilities.CreatesAnnotation;
import io.annot8.core.capabilities.CreatesContent;
import io.annot8.core.capabilities.CreatesGroup;
import io.annot8.core.capabilities.DeletesAnnotation;
import io.annot8.core.capabilities.DeletesContent;
import io.annot8.core.capabilities.DeletesGroup;
import io.annot8.core.capabilities.GroupCapability;
import io.annot8.core.capabilities.ProcessesAnnotation;
import io.annot8.core.capabilities.ProcessesContent;
import io.annot8.core.capabilities.ProcessesGroup;
import io.annot8.core.capabilities.ResourceCapability;
import io.annot8.core.capabilities.UsesResource;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;

public class AnnotationBasedCapabilities
implements Capabilities {
    private final Class<?> clazz;

    public AnnotationBasedCapabilities(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Stream<AnnotationCapability> getCreatedAnnotations() {
        return this.extractFromAnnotations(CreatesAnnotation.class, AnnotationCapability::new);
    }

    public Stream<AnnotationCapability> getProcessedAnnotations() {
        return this.extractFromAnnotations(ProcessesAnnotation.class, AnnotationCapability::new);
    }

    public Stream<AnnotationCapability> getDeletedAnnotations() {
        return this.extractFromAnnotations(DeletesAnnotation.class, AnnotationCapability::new);
    }

    public Stream<GroupCapability> getProcessedGroups() {
        return this.extractFromAnnotations(ProcessesGroup.class, GroupCapability::new);
    }

    public Stream<GroupCapability> getCreatedGroups() {
        return this.extractFromAnnotations(CreatesGroup.class, GroupCapability::new);
    }

    public Stream<GroupCapability> getDeletedGroups() {
        return this.extractFromAnnotations(DeletesGroup.class, GroupCapability::new);
    }

    public Stream<ContentCapability> getCreatedContent() {
        return this.extractFromAnnotations(CreatesContent.class, ContentCapability::new);
    }

    public Stream<ContentCapability> getDeletedContent() {
        return this.extractFromAnnotations(DeletesContent.class, ContentCapability::new);
    }

    public Stream<ContentCapability> getProcessedContent() {
        return this.extractFromAnnotations(ProcessesContent.class, ContentCapability::new);
    }

    public Stream<ResourceCapability> getUsedResources() {
        return this.extractFromAnnotations(UsesResource.class, ResourceCapability::new);
    }

    protected <A extends Annotation, T> Stream<T> extractFromAnnotations(Class<A> annotationClass, Function<A, T> extractor) {
        Annotation[] annotations = this.clazz.getAnnotationsByType(annotationClass);
        return Arrays.stream(annotations).map(extractor).distinct();
    }
}

