/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.data.content;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.data.Content;
import io.annot8.common.data.bounds.SpanBounds;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface Text
extends Content<String> {
    default public Optional<String> getText(Annotation annotation) {
        Bounds bounds = annotation.getBounds();
        return bounds.getData((Content)this, String.class);
    }

    default public Stream<Annotation> getBetween(int begin, int end) {
        SpanBounds offset = new SpanBounds(begin, end);
        return this.filterAnnotations(SpanBounds.class, s -> offset.isWithin(s.getBegin(), s.getEnd()));
    }

    default public Stream<Annotation> getCovers(int begin, int end) {
        return this.filterAnnotations(SpanBounds.class, s -> s.isWithin(begin, end));
    }

    default public Stream<Annotation> getAfter(int offset) {
        return this.filterAnnotations(SpanBounds.class, s -> s.isAfter(offset));
    }

    default public Stream<Annotation> getBefore(int offset) {
        return this.filterAnnotations(SpanBounds.class, s -> s.isBefore(offset));
    }

    private <T extends Bounds> Stream<Annotation> filterAnnotations(Class<T> boundsClass, Predicate<T> predicate) {
        return this.getAnnotations().getByBounds(boundsClass).filter(a -> predicate.test((Bounds)a.getBounds(boundsClass).get()));
    }
}

