/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.data.bounds;

import io.annot8.api.bounds.Bounds;
import io.annot8.api.data.Content;
import io.annot8.api.exceptions.InvalidBoundsException;
import java.util.Objects;
import java.util.Optional;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbTransient;

public class SpanBounds
implements Bounds {
    private final int begin;
    private final int end;

    @JsonbCreator
    public SpanBounds(@JsonbProperty(value="begin") int begin, @JsonbProperty(value="end") int end) {
        if (begin < 0) {
            throw new InvalidBoundsException("Begin must be greater than or equal to 0");
        }
        if (end < begin) {
            throw new InvalidBoundsException("End must be greater than or equal to Begin");
        }
        this.begin = begin;
        this.end = end;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    @JsonbTransient
    public int getLength() {
        return this.end - this.begin;
    }

    public <D, C extends Content<D>, R> Optional<R> getData(C content, Class<R> requiredClass) {
        Object data = content.getData();
        if (requiredClass.isAssignableFrom(String.class) && data.getClass().equals(String.class)) {
            String s = (String)data;
            int normBegin = Math.max(0, this.begin);
            int normEnd = Math.min(s.length(), this.end);
            String r = s.substring(normBegin, normEnd);
            return Optional.of(r);
        }
        return Optional.empty();
    }

    public <D, C extends Content<D>> boolean isValid(C content) {
        Object data = content.getData();
        if (data.getClass().equals(String.class)) {
            String s = (String)data;
            return this.end <= s.length();
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + " [begin=" + this.begin + ", end=" + this.end + "]";
    }

    public int hashCode() {
        return Objects.hash(this.begin, this.end);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SpanBounds)) {
            return false;
        }
        SpanBounds sb = (SpanBounds)o;
        return Objects.equals(this.begin, sb.getBegin()) && Objects.equals(this.end, sb.getEnd());
    }

    public boolean isWithin(int begin, int end) {
        return this.begin <= begin && end <= this.end;
    }

    public boolean isWithin(SpanBounds other) {
        return this.isWithin(other.getBegin(), other.getEnd());
    }

    public boolean isBefore(int offset) {
        return this.getEnd() < offset;
    }

    public boolean isBefore(SpanBounds other) {
        return this.isBefore(other.getBegin());
    }

    public boolean isAfter(SpanBounds other) {
        return this.isAfter(other.getEnd());
    }

    public boolean isAfter(int offset) {
        return this.getBegin() > offset;
    }

    public boolean isSame(SpanBounds other) {
        return this.getBegin() == other.getBegin() && this.getEnd() == other.getEnd();
    }

    public boolean isOverlaps(SpanBounds other) {
        return !this.isAfter(other) && !this.isBefore(other);
    }
}

