/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.data.bounds;

import io.annot8.api.bounds.Bounds;
import io.annot8.api.data.Content;
import io.annot8.api.exceptions.InvalidBoundsException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

public class PositionBounds
implements Bounds {
    private final int position;

    @JsonbCreator
    public PositionBounds(@JsonbProperty(value="position") int position) {
        if (position < 0) {
            throw new InvalidBoundsException("Position must be greater than or equal to 0");
        }
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public <D, C extends Content<D>, R> Optional<R> getData(C content, Class<R> requiredClass) {
        String s;
        if (this.position < 0) {
            return Optional.empty();
        }
        Object data = content.getData();
        if (data.getClass().isArray()) {
            Object[] objArr = (Object[])data;
            if (this.position < objArr.length && requiredClass.isAssignableFrom(objArr[this.position].getClass())) {
                return Optional.of(objArr[this.position]);
            }
        } else if (data instanceof List) {
            List list = (List)data;
            if (this.position < list.size() && requiredClass.isAssignableFrom(list.get(this.position).getClass())) {
                return Optional.of(list.get(this.position));
            }
        } else if (data instanceof String && this.position < (s = (String)data).length()) {
            if (requiredClass.isAssignableFrom(String.class)) {
                return Optional.of(s.substring(this.position, this.position + 1));
            }
            if (requiredClass.isAssignableFrom(Character.class)) {
                char c = s.charAt(this.position);
                return Optional.of(Character.valueOf(c));
            }
        }
        return Optional.empty();
    }

    public <D, C extends Content<D>> boolean isValid(C content) {
        if (this.position < 0) {
            return false;
        }
        Object data = content.getData();
        if (data.getClass().isArray()) {
            Object[] objArr = (Object[])data;
            return this.position < objArr.length;
        }
        if (data instanceof List) {
            List list = (List)data;
            return this.position < list.size();
        }
        if (data instanceof String) {
            String s = (String)data;
            return this.position < s.length();
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + " [position=" + this.position + "]";
    }

    public int hashCode() {
        return Objects.hash(this.position);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PositionBounds)) {
            return false;
        }
        PositionBounds pb = (PositionBounds)o;
        return Objects.equals(this.position, pb.getPosition());
    }

    public boolean isBefore(PositionBounds other) {
        return this.getPosition() < other.getPosition();
    }

    public boolean isAfter(PositionBounds other) {
        return this.getPosition() > other.getPosition();
    }

    public boolean isSame(PositionBounds other) {
        return this.getPosition() == other.getPosition();
    }
}

