/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.components.metering;

import io.annot8.api.components.Annot8Component;
import io.annot8.common.components.metering.Metrics;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.Map;
import java.util.function.ToDoubleFunction;

public class NamedMetrics
implements Metrics {
    private final MeterRegistry meterRegistry;
    private final String prefix;

    public NamedMetrics(MeterRegistry meterRegistry, String prefix, String name) {
        this(meterRegistry, String.format("%s-%s", prefix, name));
    }

    public NamedMetrics(MeterRegistry meterRegistry, String prefix, Class<? extends Annot8Component> clazz) {
        this(meterRegistry, prefix, clazz.getName());
    }

    protected NamedMetrics(MeterRegistry meterRegistry, String prefix) {
        this.meterRegistry = meterRegistry;
        this.prefix = prefix;
    }

    private String getName(String name) {
        return String.format("%s-%s", this.prefix, name);
    }

    @Override
    public Counter counter(String name, Iterable<Tag> tags) {
        return this.meterRegistry.counter(this.getName(name), tags);
    }

    @Override
    public Counter counter(String name, String ... tags) {
        return this.meterRegistry.counter(this.getName(name), tags);
    }

    @Override
    public DistributionSummary summary(String name, Iterable<Tag> tags) {
        return this.meterRegistry.summary(this.getName(name), tags);
    }

    @Override
    public DistributionSummary summary(String name, String ... tags) {
        return this.meterRegistry.summary(this.getName(name), tags);
    }

    @Override
    public Timer timer(String name, Iterable<Tag> tags) {
        return this.meterRegistry.timer(this.getName(name), tags);
    }

    @Override
    public Timer timer(String name, String ... tags) {
        return this.meterRegistry.timer(this.getName(name), tags);
    }

    @Override
    public <T> T gauge(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> valueFunction) {
        return (T)this.meterRegistry.gauge(this.getName(name), tags, obj, valueFunction);
    }

    @Override
    public <T extends Number> T gauge(String name, Iterable<Tag> tags, T number) {
        return (T)this.meterRegistry.gauge(this.getName(name), tags, number);
    }

    @Override
    public <T extends Number> T gauge(String name, T number) {
        return (T)this.meterRegistry.gauge(this.getName(name), number);
    }

    @Override
    public <T> T gauge(String name, T obj, ToDoubleFunction<T> valueFunction) {
        return (T)this.meterRegistry.gauge(this.getName(name), obj, valueFunction);
    }

    @Override
    public <T extends Collection<?>> T gaugeCollectionSize(String name, Iterable<Tag> tags, T collection) {
        return (T)this.meterRegistry.gaugeCollectionSize(this.getName(name), tags, collection);
    }

    @Override
    public <T extends Map<?, ?>> T gaugeMapSize(String name, Iterable<Tag> tags, T map) {
        return (T)this.meterRegistry.gaugeMapSize(this.getName(name), tags, map);
    }
}

