/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.api.stores;

import io.annot8.api.annotations.Group;
import io.annot8.api.data.Item;
import io.annot8.api.filters.Filter;
import io.annot8.api.helpers.WithFilter;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface GroupStore
extends WithFilter<Group> {
    public Item getItem();

    public Group.Builder getBuilder();

    default public Group.Builder create() {
        return this.getBuilder();
    }

    default public Group.Builder copy(Group existing) {
        return (Group.Builder)((Group.Builder)this.getBuilder().from(existing)).newId();
    }

    default public Group.Builder edit(Group existing) {
        return (Group.Builder)this.getBuilder().from(existing);
    }

    public void delete(Group var1);

    default public void delete(Collection<Group> groups) {
        groups.forEach(this::delete);
    }

    default public void deleteAll() {
        this.delete(this.getAll().collect(Collectors.toList()));
    }

    public Stream<Group> getAll();

    default public Stream<Group> getByType(String type) {
        return this.getAll().filter((? super T a) -> type.equals(a.getType()));
    }

    public Optional<Group> getById(String var1);

    @Override
    default public Stream<Group> filter(Filter<Group> filter) {
        return this.getAll().filter(filter::test);
    }
}

