/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.api.components.responses;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public interface ProcessorResponse {
    public static ProcessorResponseBuilder ok() {
        return new ProcessorResponseBuilder(Status.OK);
    }

    public static ProcessorResponseBuilder itemError() {
        return new ProcessorResponseBuilder(Status.ITEM_ERROR);
    }

    public static ProcessorResponseBuilder itemError(Collection<Exception> exceptions) {
        return new ProcessorResponseBuilder(Status.ITEM_ERROR, exceptions);
    }

    public static ProcessorResponseBuilder itemError(Exception ... exceptions) {
        return new ProcessorResponseBuilder(Status.ITEM_ERROR, Arrays.asList(exceptions));
    }

    public static ProcessorResponseBuilder processingError() {
        return new ProcessorResponseBuilder(Status.PROCESSOR_ERROR);
    }

    public static ProcessorResponseBuilder processingError(Collection<Exception> exceptions) {
        return new ProcessorResponseBuilder(Status.PROCESSOR_ERROR, exceptions);
    }

    public static ProcessorResponseBuilder processingError(Exception ... exceptions) {
        return new ProcessorResponseBuilder(Status.PROCESSOR_ERROR, Arrays.asList(exceptions));
    }

    public Status getStatus();

    public Collection<Exception> getExceptions();

    default public boolean hasExceptions() {
        return !this.getExceptions().isEmpty();
    }

    public static class ProcessorResponseBuilder
    implements ProcessorResponse {
        private final Status status;
        private final Collection<Exception> exceptions;

        protected ProcessorResponseBuilder(Status status) {
            this.status = status;
            this.exceptions = Collections.emptyList();
        }

        protected ProcessorResponseBuilder(Status status, Collection<Exception> exceptions) {
            this.status = status;
            this.exceptions = exceptions;
        }

        @Override
        public Status getStatus() {
            return this.status;
        }

        @Override
        public Collection<Exception> getExceptions() {
            return this.exceptions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessorResponseBuilder that = (ProcessorResponseBuilder)o;
            return this.status == that.status;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.status});
        }

        public String toString() {
            return this.status.toString();
        }
    }

    public static enum Status {
        OK,
        ITEM_ERROR,
        PROCESSOR_ERROR;

    }
}

