/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.api.annotations;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.data.Content;
import io.annot8.api.helpers.WithId;
import io.annot8.api.helpers.WithProperties;
import io.annot8.api.helpers.WithType;
import io.annot8.api.helpers.builders.WithFromBuilder;
import io.annot8.api.helpers.builders.WithIdBuilder;
import io.annot8.api.helpers.builders.WithNewIdBuilder;
import io.annot8.api.helpers.builders.WithPropertiesBuilder;
import io.annot8.api.helpers.builders.WithSave;
import io.annot8.api.helpers.builders.WithTypeBuilder;
import io.annot8.api.references.AnnotationReference;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Group
extends WithId,
WithType,
WithProperties {
    default public Map<String, Stream<Annotation>> getAnnotations() {
        return this.getReferences().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> AnnotationReference.toAnnotations((Stream)e.getValue())));
    }

    public Map<String, Stream<AnnotationReference>> getReferences();

    default public Stream<Annotation> getAnnotations(String role) {
        if (this.getAnnotations().containsKey(role)) {
            return this.getAnnotations().get(role);
        }
        return Stream.empty();
    }

    default public Stream<String> getRoles() {
        return this.getReferences().keySet().stream().distinct();
    }

    public Optional<String> getRole(Annotation var1);

    default public Stream<Annotation> getAnnotationsForContent(Content content) {
        return this.getAnnotations().values().stream().flatMap(s -> s).filter(a -> content.getId().equals(a.getContentId()));
    }

    default public Stream<Annotation> getAnnotationsForContentAndRole(Content content, String role) {
        return this.getAnnotations(role).filter(a -> content.getId().equals(a.getContentId()));
    }

    public boolean containsAnnotation(Annotation var1);

    default public boolean containsRole(String role) {
        return this.getRoles().anyMatch(role::equals);
    }

    default public boolean sameGroup(Group other) {
        return other != null && this.getId().equals(other.getId());
    }

    public static interface Builder
    extends WithIdBuilder<Builder>,
    WithTypeBuilder<Builder>,
    WithPropertiesBuilder<Builder>,
    WithNewIdBuilder<Builder>,
    WithFromBuilder<Builder, Group>,
    WithSave<Group> {
        public Builder withAnnotation(String var1, Annotation var2);
    }
}

