/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.api.pipelines;

import io.annot8.api.components.ProcessorDescriptor;
import io.annot8.api.components.SourceDescriptor;
import io.annot8.api.exceptions.IncompleteException;
import io.annot8.api.helpers.WithDescription;
import io.annot8.api.helpers.WithName;
import io.annot8.api.pipelines.PipelineOrderer;
import java.util.Collection;

public interface PipelineDescriptor
extends WithName,
WithDescription {
    public Collection<SourceDescriptor> getSources();

    public Collection<ProcessorDescriptor> getProcessors();

    public static interface Builder {
        public Builder from(PipelineDescriptor var1);

        public Builder withName(String var1);

        public Builder withDescription(String var1);

        public Builder withOrderer(PipelineOrderer var1);

        public Builder withSource(SourceDescriptor var1);

        public Builder withProcessor(ProcessorDescriptor var1);

        default public Builder withSources(SourceDescriptor ... sources) {
            for (SourceDescriptor source : sources) {
                this.withSource(source);
            }
            return this;
        }

        default public Builder withSources(Collection<SourceDescriptor> sources) {
            sources.forEach(this::withSource);
            return this;
        }

        default public Builder withProcessors(ProcessorDescriptor ... processors) {
            for (ProcessorDescriptor processor : processors) {
                this.withProcessor(processor);
            }
            return this;
        }

        default public Builder withProcessors(Collection<ProcessorDescriptor> processors) {
            processors.forEach(this::withProcessor);
            return this;
        }

        public PipelineDescriptor build() throws IncompleteException;
    }
}

