/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.api.components.responses;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public interface SourceResponse {
    public static SourceResponseBuilder ok() {
        return new SourceResponseBuilder(Status.OK);
    }

    public static SourceResponseBuilder done() {
        return new SourceResponseBuilder(Status.DONE);
    }

    public static SourceResponseBuilder sourceError() {
        return new SourceResponseBuilder(Status.SOURCE_ERROR);
    }

    public static SourceResponseBuilder sourceError(Collection<Exception> exceptions) {
        return new SourceResponseBuilder(Status.SOURCE_ERROR, exceptions);
    }

    public static SourceResponseBuilder sourceError(Exception ... exceptions) {
        return new SourceResponseBuilder(Status.SOURCE_ERROR, Arrays.asList(exceptions));
    }

    public static SourceResponseBuilder empty() {
        return new SourceResponseBuilder(Status.EMPTY);
    }

    public Status getStatus();

    public Collection<Exception> getExceptions();

    default public boolean hasExceptions() {
        return !this.getExceptions().isEmpty();
    }

    public static class SourceResponseBuilder
    implements SourceResponse {
        private final Status status;
        private final Collection<Exception> exceptions;

        protected SourceResponseBuilder(Status status) {
            this.status = status;
            this.exceptions = Collections.emptyList();
        }

        protected SourceResponseBuilder(Status status, Collection<Exception> exceptions) {
            this.status = status;
            this.exceptions = exceptions;
        }

        @Override
        public Status getStatus() {
            return this.status;
        }

        @Override
        public Collection<Exception> getExceptions() {
            return this.exceptions;
        }

        @Override
        public boolean hasExceptions() {
            return !this.exceptions.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceResponseBuilder that = (SourceResponseBuilder)o;
            return this.status == that.status;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.status});
        }

        public String toString() {
            return this.status.toString();
        }
    }

    public static enum Status {
        OK,
        SOURCE_ERROR,
        DONE,
        EMPTY;

    }
}

