/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public interface EventTime {
    public static final DateTimeFormatter format1 = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ssx");
    public static final DateTimeFormatter format2 = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    public static final DateTimeFormatter localFormat = DateTimeFormatter.ofPattern("YYYY-MM-DD HH:mm:ss");

    public long eventTimeUnix();

    default public OffsetDateTime eventTimeLocal() {
        return EventTime.local(this.eventTimeUnix());
    }

    public static OffsetDateTime local(long unix) {
        return EventTime.local(unix, ZoneId.systemDefault());
    }

    public static OffsetDateTime local(long unix, ZoneId zone) {
        return Instant.ofEpochMilli(unix).atZone(zone).toOffsetDateTime();
    }

    public static long unix(OffsetDateTime t) {
        return t.toInstant().toEpochMilli();
    }

    public static long unix() {
        return System.currentTimeMillis();
    }

    public static long unix(String localTime) {
        OffsetDateTime parsed;
        try {
            parsed = OffsetDateTime.parse(localTime, format2);
        }
        catch (DateTimeParseException e) {
            parsed = OffsetDateTime.parse(localTime, format1);
        }
        return EventTime.unix(parsed);
    }

    public static long unix(String time, ZoneOffset offset) {
        return EventTime.unix(LocalDateTime.parse(time, localFormat).atOffset(offset));
    }
}

