/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public interface CloseableIterator<T>
extends Iterator<T>,
Closeable {
    default public long size() {
        long result = 0L;
        while (this.hasNext()) {
            ++result;
            this.next();
        }
        return result;
    }

    public static <X> CloseableIterator<X> apply(final Iterator<X> underlying) {
        return new CloseableIterator<X>(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public boolean hasNext() {
                return underlying.hasNext();
            }

            @Override
            public X next() {
                return underlying.next();
            }
        };
    }

    public static CloseableIterator<Map.Entry<ByteBuffer, ByteBuffer>> empty() {
        return CloseableIterator.apply(Collections.emptyIterator());
    }
}

