/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.storage;

import io.amient.affinity.core.util.EventTime;
import java.io.Serializable;

public class Record<K, V>
implements Serializable {
    public final K key;
    public final V value;
    public final long timestamp;
    public final boolean tombstone;

    public Record(K key, V value) {
        this(key, value, value instanceof EventTime ? ((EventTime)value).eventTimeUnix() : EventTime.unix());
    }

    public Record(K key, V value, long timestamp) {
        this.key = key;
        this.value = value;
        this.timestamp = timestamp;
        this.tombstone = false;
    }

    public Record(K key, V value, boolean tombstone) {
        this(key, value, value instanceof EventTime ? ((EventTime)value).eventTimeUnix() : EventTime.unix(), tombstone);
    }

    public Record(K key, V value, long timestamp, boolean tombstone) {
        this.key = key;
        this.value = value;
        this.timestamp = timestamp;
        this.tombstone = tombstone;
    }

    public String toString() {
        return (this.key == null ? "null" : this.key.toString()) + " " + (this.value == null ? "null" : this.value.toString()) + " @ " + EventTime.local(this.timestamp);
    }
}

