/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import io.amient.affinity.core.config.Cfg;
import io.amient.affinity.core.config.CfgBool;
import io.amient.affinity.core.config.CfgCls;
import io.amient.affinity.core.config.CfgGroup;
import io.amient.affinity.core.config.CfgInt;
import io.amient.affinity.core.config.CfgIntList;
import io.amient.affinity.core.config.CfgList;
import io.amient.affinity.core.config.CfgLong;
import io.amient.affinity.core.config.CfgNested;
import io.amient.affinity.core.config.CfgPath;
import io.amient.affinity.core.config.CfgString;
import io.amient.affinity.core.config.CfgStringList;
import io.amient.affinity.core.config.CfgUrl;
import java.net.URL;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;

public class CfgStruct<T extends CfgStruct>
extends Cfg<T>
implements CfgNested {
    public final List<Cfg.Options> options;
    protected List<Map.Entry<String, Cfg<?>>> properties = new LinkedList();
    protected List<Map.Entry<String, CfgString>> externalProperties = new LinkedList<Map.Entry<String, CfgString>>();
    private Config config;
    protected CfgStruct<?> parent = null;
    private List<CfgStruct<?>> children = new LinkedList();
    Set<String> extensions = new HashSet<String>(){
        {
            this.addAll(CfgStruct.this.specializations());
        }
    };

    protected Set<String> specializations() {
        return Collections.emptySet();
    }

    protected void addChild(CfgStruct<?> child) {
        this.children.add(child);
    }

    @Override
    public CfgStruct<T> doc(String description) {
        super.doc(description);
        return this;
    }

    @Override
    public boolean isDefined() {
        return this.properties.stream().filter(p -> ((Cfg)p.getValue()).isRequired() && !((Cfg)p.getValue()).isDefined()).count() == 0L;
    }

    public CfgStruct(Class<? extends CfgStruct<?>> inheritFrom, Cfg.Options ... options) {
        this.options = Arrays.asList(options);
        try {
            CfgStruct<?> inheritedCfg = inheritFrom.newInstance();
            inheritedCfg.properties.forEach(p -> this.extensions.add((String)p.getKey()));
            inheritedCfg.extensions.forEach(e -> this.extensions.add((String)e));
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        this.setValue(this);
    }

    public CfgStruct() {
        this(Cfg.Options.STRICT);
    }

    public CfgStruct(Cfg.Options ... options) {
        this.options = Arrays.asList(options);
        this.setValue(this);
    }

    @Override
    public void setPath(String path) {
        super.setPath(path);
        this.properties.forEach(entry -> ((Cfg)entry.getValue()).setPath(this.path((String)entry.getKey())));
    }

    public final T apply(CfgStruct<?> conf) throws IllegalArgumentException {
        if (conf.path() == null) {
            throw new IllegalArgumentException();
        }
        if (conf.parent != null && conf.parent.getClass().isAssignableFrom(this.getClass())) {
            return (T)conf.parent;
        }
        Cfg z = this.apply(conf.config());
        AtomicReference<Cfg> self = new AtomicReference<Cfg>(z);
        ((CfgStruct)self.get()).setPath(conf.path());
        conf.children.forEach(x -> {
            if (((CfgStruct)self.get()).getClass().isAssignableFrom(x.getClass())) {
                self.set((Cfg)x);
            }
        });
        CfgStruct result = (CfgStruct)self.get();
        result.parent = conf;
        if (result == z) {
            conf.addChild(result);
        }
        return (T)result;
    }

    public final T apply(Map<String, ?> config) {
        return (T)this.apply(ConfigFactory.parseMap(config));
    }

    public T apply(Config config) throws IllegalArgumentException {
        if (config != null) {
            this.config = this.path().isEmpty() ? config : (this.listPos > -1 ? (Config)config.getConfigList(this.relPath).get(this.listPos) : config.getConfig(this.relPath));
            StringBuilder errors = new StringBuilder();
            this.properties.forEach(entry -> {
                String propPath = (String)entry.getKey();
                Cfg cfg = (Cfg)entry.getValue();
                try {
                    if (propPath == null || propPath.isEmpty()) {
                        cfg.apply(this.config);
                    } else if (this.config.hasPath(propPath)) {
                        cfg.apply(this.config);
                    }
                    if (cfg.required && !cfg.isDefined()) {
                        throw new IllegalArgumentException(propPath + " is required" + (this.path().isEmpty() ? "" : " in " + this.path()));
                    }
                }
                catch (IllegalArgumentException e) {
                    errors.append(e.getMessage() + "\n");
                }
            });
            this.externalProperties.clear();
            this.config.entrySet().forEach(entry -> {
                boolean allowedViaExtensions;
                boolean existingProperty = this.properties.stream().filter(p -> ((String)p.getKey()).equals(entry.getKey()) || p.getValue() instanceof CfgNested && ((String)entry.getKey()).startsWith((String)p.getKey() + ".")).count() > 0L;
                boolean bl = allowedViaExtensions = this.extensions.stream().filter(s -> s.equals(entry.getKey()) || ((String)entry.getKey()).startsWith(s + ".")).count() > 0L;
                if (!existingProperty && !allowedViaExtensions) {
                    if (!this.options.contains((Object)Cfg.Options.IGNORE_UNKNOWN)) {
                        errors.append((String)entry.getKey() + " is not a known property" + (this.path().isEmpty() ? "" : " of " + this.path()) + "\n");
                    } else {
                        CfgString c = new CfgString();
                        c.setValue(((ConfigValue)entry.getValue()).unwrapped().toString());
                        this.externalProperties.add(new AbstractMap.SimpleEntry(entry.getKey(), c));
                    }
                }
            });
            String errorMessage = errors.toString();
            if (!errorMessage.isEmpty()) {
                throw new IllegalArgumentException(errorMessage);
            }
            return (T)this;
        }
        return (T)this;
    }

    @Override
    public String parameterInfo() {
        return "";
    }

    Config config() {
        return this.config;
    }

    public CfgString string(String path, boolean required) {
        return this.add(path, new CfgString(), required, Optional.empty());
    }

    public CfgString string(String path, String defaultValue) {
        return this.add(path, new CfgString(), true, Optional.of(defaultValue));
    }

    public CfgStringList stringlist(String path, List<String> defaultValue) {
        return this.add(path, new CfgStringList(), true, Optional.of(defaultValue));
    }

    public CfgStringList stringlist(String path, boolean required) {
        return this.add(path, new CfgStringList(), required, Optional.empty());
    }

    public CfgLong longint(String path, boolean required) {
        return this.add(path, new CfgLong(), required, Optional.empty());
    }

    public CfgLong longint(String path, long defaultValue) {
        return this.add(path, new CfgLong(), true, Optional.of(defaultValue));
    }

    public CfgBool bool(String path, boolean required) {
        return this.add(path, new CfgBool(), required, Optional.empty());
    }

    public CfgBool bool(String path, boolean required, boolean defaultValue) {
        return this.add(path, new CfgBool(), required, Optional.of(defaultValue));
    }

    public CfgInt integer(String path, boolean required) {
        return this.add(path, new CfgInt(), required, Optional.empty());
    }

    public CfgInt integer(String path, Integer defaultValue) {
        return this.add(path, new CfgInt(), true, Optional.of(defaultValue));
    }

    public CfgIntList intlist(String path, boolean required) {
        return this.add(path, new CfgIntList(), required, Optional.empty());
    }

    public CfgIntList intlist(String path, List<Integer> defaultValue) {
        return this.add(path, new CfgIntList(), true, Optional.of(defaultValue));
    }

    public CfgUrl url(String path, boolean required) {
        return this.add(path, new CfgUrl(), required, Optional.empty());
    }

    public CfgUrl url(String path, URL defaultVal) {
        return this.add(path, new CfgUrl(), true, Optional.of(defaultVal));
    }

    public CfgPath filepath(String path, boolean required) {
        return this.add(path, new CfgPath(), required, Optional.empty());
    }

    public CfgPath filepath(String path, Path defaultVal) {
        return this.add(path, new CfgPath(), true, Optional.of(defaultVal));
    }

    public <X> CfgCls<X> cls(String path, Class<X> c, boolean required) {
        return this.add(path, new CfgCls<X>(c), required, Optional.empty());
    }

    public <X> CfgCls<X> cls(String path, Class<X> c, Class<? extends X> defaultVal) {
        return this.add(path, new CfgCls<X>(c), true, Optional.of(defaultVal));
    }

    public <X extends CfgStruct<X>> X struct(String path, X obj, boolean required) {
        X x = this.add(path, obj, required, Optional.empty());
        obj.setValue(obj);
        return x;
    }

    public <X extends CfgStruct<X>> X ref(X obj, boolean required) {
        return this.add(null, obj, required, Optional.empty());
    }

    public <X extends Cfg<?>> CfgGroup<X> group(String path, Class<X> c, boolean required) {
        return this.add(path, new CfgGroup<X>(c), required, Optional.empty());
    }

    public <X extends Cfg<?>> CfgGroup<X> group(String path, CfgGroup<X> obj, boolean required) {
        return this.add(path, obj, required, Optional.empty());
    }

    public <X> CfgList<X> list(String path, Class<X> c, boolean required) {
        return this.add(path, new CfgList(c), required, Optional.empty());
    }

    private <Y, X extends Cfg<Y>> X add(String itemRelPath, X cfg, boolean required, Optional<Y> defaultValue) {
        cfg.setRelPath(itemRelPath);
        cfg.setPath(this.path() + itemRelPath);
        if (defaultValue.isPresent()) {
            cfg.setDefaultValue(defaultValue.get());
        }
        if (!required) {
            cfg.setOptional();
        }
        this.properties.add(new AbstractMap.SimpleEntry<String, X>(itemRelPath, cfg));
        return cfg;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof CfgStruct)) {
            return false;
        }
        CfgStruct that = (CfgStruct)other;
        if (this.properties.size() != that.properties.size()) {
            return false;
        }
        for (int i = 0; i < this.properties.size(); ++i) {
            boolean same;
            Map.Entry<String, Cfg<?>> left = this.properties.get(i);
            Map.Entry<String, Cfg<?>> right = that.properties.get(i);
            boolean bl = same = left.getKey().equals(right.getKey()) && left.getValue().equals(right.getValue());
            if (same) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{");
        this.properties.forEach(entry -> {
            if (result.length() > 1) {
                result.append(", ");
            }
            result.append((String)entry.getKey());
            result.append(": ");
            result.append(entry.getValue());
        });
        result.append("}");
        return result.toString();
    }

    public Map<String, Cfg<?>> toMap() {
        TreeMap result = new TreeMap();
        this.properties.forEach(prop -> {
            Cfg cfr_ignored_0 = (Cfg)result.put((String)prop.getKey(), (Cfg<?>)prop.getValue());
        });
        this.externalProperties.forEach(prop -> {
            Cfg cfr_ignored_0 = (Cfg)result.put((String)prop.getKey(), (Cfg<?>)prop.getValue());
        });
        return result;
    }
}

