/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.storage;

import com.codahale.metrics.MetricRegistry;
import io.amient.affinity.core.state.StateConf;
import io.amient.affinity.core.storage.MemStore;
import io.amient.affinity.core.util.ByteUtils;
import io.amient.affinity.core.util.CloseableIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class MemStoreSimpleMap
extends MemStore {
    private final ConcurrentHashMap<ByteBuffer, byte[]> internal = new ConcurrentHashMap();

    public MemStoreSimpleMap(String identifier, StateConf conf, MetricRegistry metrics) throws IOException {
        super(conf);
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public CloseableIterator<Map.Entry<ByteBuffer, ByteBuffer>> iterator(ByteBuffer prefix) {
        if (prefix != null) {
            throw new UnsupportedOperationException("MemStoreSimpleMap doesn't support prefixes, use MemStoreSortedMap instead");
        }
        return new CloseableIterator<Map.Entry<ByteBuffer, ByteBuffer>>(){
            Iterator<Map.Entry<ByteBuffer, byte[]>> underlying;
            {
                this.underlying = MemStoreSimpleMap.this.internal.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.underlying.hasNext();
            }

            @Override
            public Map.Entry<ByteBuffer, ByteBuffer> next() {
                Map.Entry<ByteBuffer, byte[]> entry = this.underlying.next();
                return new AbstractMap.SimpleEntry<ByteBuffer, ByteBuffer>(entry.getKey(), ByteBuffer.wrap(entry.getValue()));
            }

            @Override
            public void close() throws IOException {
                MemStoreSimpleMap.this.close();
            }
        };
    }

    @Override
    public Optional<ByteBuffer> apply(ByteBuffer key) {
        return Optional.ofNullable(this.internal.get(key)).map(ByteBuffer::wrap);
    }

    @Override
    public long numKeys() {
        return this.internal.size();
    }

    @Override
    public void put(ByteBuffer key, ByteBuffer value) {
        this.internal.put(key, ByteUtils.bufToArray(value));
    }

    @Override
    public void remove(ByteBuffer key) {
        this.internal.remove(key);
    }

    @Override
    public String getStats() {
        return "size = " + this.internal.size();
    }

    @Override
    public void erase() {
        this.internal.clear();
    }

    @Override
    public void close() throws IOException {
        this.internal.clear();
    }
}

