/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.state;

import com.typesafe.config.Config;
import io.amient.affinity.core.config.Cfg;
import io.amient.affinity.core.config.CfgStruct;
import io.amient.affinity.core.storage.LogStorageConf;
import io.amient.affinity.core.storage.MemStore;

public class StateConf
extends CfgStruct<StateConf> {
    public Cfg<Integer> TtlSeconds = this.integer("ttl.sec", -1).doc("Per-record expiration which will based off event-time if the data class implements EventTime trait");
    public Cfg<Boolean> External = this.bool("external", true, false).doc("If the state is attached to a data stream which is populated and partitioned by an external process - external state becomes readonly. Number of partitions will be also detected from the underlying storage log.");
    public Cfg<Integer> Partitions = this.integer("partitions", false).doc("Number of partitions (this setting cannot be applied to state stores defined within a Keyspace)");
    public Cfg<Long> MinTimestampUnixMs = this.longint("min.timestamp.ms", 0L).doc("Any records with timestamp lower than this value will be immediately dropped");
    public LogStorageConf Storage = this.struct("storage", new LogStorageConf(), false);
    public MemStore.MemStoreConf MemStore = this.struct("memstore", new MemStore.MemStoreConf(), true);
    public Cfg<Long> LockTimeoutMs = this.longint("lock.timeout.ms", 10000L).doc("How long a lock can be held by a single thread before throwing a TimeoutException");
    public Cfg<Long> WriteTimeoutMs = this.longint("write.timeout.ms", 10000L).doc("How long can any of the write operation on a global store take before throwing a TimeoutException");

    @Override
    public StateConf apply(Config config) throws IllegalArgumentException {
        StateConf self = (StateConf)super.apply(config);
        if (this.External.apply().booleanValue() && this.Partitions.isDefined()) {
            throw new IllegalArgumentException("State cannot be both external and have defined number of partitions");
        }
        return self;
    }
}

