/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.util;

import io.amient.affinity.core.util.ZkConf;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClients {
    private static final Logger log = LoggerFactory.getLogger(ZkClients.class);
    private static volatile Map<ZkConf, ZkClient> clients = new HashMap<ZkConf, ZkClient>();
    private static volatile Map<ZkConf, Integer> refs = new HashMap<ZkConf, Integer>();

    public static synchronized ZkClient get(ZkConf conf) {
        ZkClient client = clients.get(conf);
        if (client == null) {
            client = new ZkClient(conf.Connect.apply(), conf.SessionTimeoutMs.apply().intValue(), conf.ConnectTimeoutMs.apply().intValue(), new ZkSerializer(){

                public byte[] serialize(Object o) {
                    return o.toString().getBytes();
                }

                public Object deserialize(byte[] bytes) {
                    return new String(bytes);
                }
            });
            clients.put(conf, client);
            refs.put(conf, 0);
        }
        if (!refs.containsKey(conf)) {
            throw new IllegalStateException();
        }
        int refCount = refs.get(conf) + 1;
        log.debug("Opening zkClient refCount=" + refCount + " refs=" + refs.size() + ", conf" + conf);
        refs.put(conf, refCount);
        return client;
    }

    public static synchronized void close(ZkClient client) {
        AtomicReference _conf = new AtomicReference();
        clients.forEach((a, b) -> {
            if (client == b) {
                _conf.set(a);
            }
        });
        ZkConf conf = (ZkConf)_conf.get();
        if (conf == null || !refs.containsKey(conf)) {
            throw new IllegalStateException();
        }
        if (refs.get(conf) > 0) {
            int refCount = refs.get(conf) - 1;
            refs.put(conf, refCount);
            if (refCount == 0) {
                refs.remove(conf);
                log.debug("Closing zkClient refCount=" + refCount + " refs=" + refs.size() + ", conf" + conf);
                client.close();
                clients.remove(conf);
            }
        } else {
            throw new IllegalStateException();
        }
    }
}

