/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.util;

import java.util.regex.Pattern;

public class Text {
    public static final String fulltextSet = "\\p{L}\\p{M}\\p{N}\\p{Z}\\p{P}\\p{S}\\r\\n\\t\\s";
    public static final Pattern fulltext = Pattern.compile("^[\\p{L}\\p{M}\\p{N}\\p{Z}\\p{P}\\p{S}\\r\\n\\t\\s]+$");
    public static final Pattern fulltextFilter = Pattern.compile("[^\\p{L}\\p{M}\\p{N}\\p{Z}\\p{P}\\p{S}\\r\\n\\t\\s]");
    public static final String literalSet = "\\p{L}\\p{M}\\p{N}\\p{P}\\p{S}";
    public static final Pattern literal = Pattern.compile("^[\\p{L}\\p{M}\\p{N}\\p{P}\\p{S}]+$");
    public static final Pattern literalFilter = Pattern.compile("[^\\p{L}\\p{M}\\p{N}\\p{P}\\p{S}]");
    public static final String plaintextSet = "\\p{L}\\p{M}\\p{N}\\p{Z}\\p{P}\\p{Sc}";
    public static final Pattern plaintext = Pattern.compile("^[\\p{L}\\p{M}\\p{N}\\p{Z}\\p{P}\\p{Sc}]+$");
    public static final Pattern plaintextFilter = Pattern.compile("[^\\p{L}\\p{M}\\p{N}\\p{Z}\\p{P}\\p{Sc}]");
    public static final String alphanumSet = "\\p{L}\\p{M}\\p{N}\\-_";
    public static final Pattern alphanum = Pattern.compile("^[\\p{L}\\p{M}\\p{N}\\-_]+$");
    public static final Pattern alphanumFilter = Pattern.compile("[^\\p{L}\\p{M}\\p{N}\\-_]");
    public static final String nominalSet = "\\p{L}\\p{M}\\-'\\u2018\\u2019\\u201B\\u2032\\u2013\\u2014";
    public static final Pattern nominal = Pattern.compile("^[\\p{L}\\p{M}\\-'\\u2018\\u2019\\u201B\\u2032\\u2013\\u2014]+$");
    public static final Pattern nominalFilter = Pattern.compile("[^\\p{L}\\p{M}\\-'\\u2018\\u2019\\u201B\\u2032\\u2013\\u2014]");
    public static final String numeralSet = "\\p{N}";
    public static final Pattern numeral = Pattern.compile("^[\\p{N}]+$");
    public static final Pattern numeralFilter = Pattern.compile("[^\\p{N}]");
    public static final String decimalSet = "0-9";
    public static final Pattern decimal = Pattern.compile("^[0-9]+$");
    public static final Pattern decimalFilter = Pattern.compile("[^0-9]");
    public static final String controlSet = "\\p{C}";
    public static final Pattern control = Pattern.compile("^[\\p{C}]+$");
    public static final Pattern controlFilter = Pattern.compile("[^\\p{C}]");

    public static String apply(Pattern pattern, String input) {
        if (pattern.pattern().startsWith("^")) {
            throw new RuntimeException("Cannot use anchored regex for filtering");
        }
        return pattern.matcher(input).replaceAll("");
    }

    public static boolean is(Pattern pattern, String input) {
        if (!pattern.pattern().startsWith("^")) {
            throw new RuntimeException("Must use anchored regex for matching");
        }
        return pattern.matcher(input).matches();
    }

    public static void require(String field, Pattern pattern, String input) {
        if (!Text.is(pattern, input)) {
            String error = pattern == fulltext ? "Control characters are not allowed in " + field : (pattern == literal ? "Whitespace and line feed characters are not allowed in " + field : (pattern == plaintext ? "Controls, special characters, tabs and line feed characters are not allowed in " + field : (pattern == alphanum ? "Only letters, accents and numbers are allowed in" + field : (pattern == nominal ? "Only letters, dashes and apostrophes are allowed in " + field : (pattern == numeral ? "Only numerals are allowed in " + field : (pattern == decimal ? "Only decimal number characters are allowed in " + field : "Illegal characters detected in " + field))))));
            throw new IllegalArgumentException(error);
        }
    }
}

