/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;

public class ByteUtils {
    private static final String HEX = "0123456789abcdef";

    public static byte[] bufToArray(ByteBuffer b) {
        if (b.hasArray()) {
            if (b.position() == 0 && b.arrayOffset() == 0 && b.limit() == b.capacity()) {
                return b.array();
            }
            return Arrays.copyOfRange(b.array(), b.arrayOffset(), b.arrayOffset() + b.remaining());
        }
        byte[] a = new byte[b.remaining()];
        int bp = b.position();
        b.get(a);
        b.position(bp);
        return a;
    }

    public static byte[] reverse(byte[] src) {
        byte[] dest = new byte[src.length];
        ByteUtils.reverse(src, dest, 0);
        return dest;
    }

    public static void reverse(byte[] src, byte[] dest, int destOffset) {
        int i = destOffset;
        for (int j = Math.min(dest.length - 1, src.length - 1); j >= 0 && i < dest.length; --j, ++i) {
            dest[i] = src[j];
        }
    }

    public static int parseIntRadix10(byte[] array, int offset, int limit) {
        int result = 0;
        boolean negative = false;
        if (array[offset] == 45) {
            negative = true;
            ++offset;
        }
        for (int i = offset; i <= limit; ++i) {
            if (array[i] < 48 || array[i] > 57) {
                throw new IllegalArgumentException("Invalid numeric character " + (char)array[i]);
            }
            result *= 10;
            result += array[i] - 48;
        }
        return negative ? -result : result;
    }

    public static long parseLongRadix10(byte[] array, int offset, int limit) {
        long result = 0L;
        for (int i = offset; i <= limit; ++i) {
            if (array[i] < 48 || array[i] > 57) {
                throw new IllegalArgumentException("Invalid numeric character " + (char)array[i]);
            }
            result *= 10L;
            result += (long)(array[i] - 48);
        }
        return result;
    }

    public static long parseLongRadix16(byte[] array, int offset, int limit) {
        long result = 0L;
        for (int i = offset; i <= limit; ++i) {
            result *= 16L;
            result += (long)ByteUtils.parseRadix16Byte(array[i]);
        }
        return result;
    }

    public static byte[] parseRadix16(byte[] array, int offset, int len) {
        byte[] result = new byte[len / 2];
        ByteUtils.parseRadix16(array, offset, len, result, 0);
        return result;
    }

    public static void parseRadix16(byte[] array, int offset, int len, byte[] dest, int destOffset) {
        int limit = Math.min(offset + len, array.length);
        int j = destOffset;
        int i = offset;
        while (i < limit) {
            dest[j] = (byte)(ByteUtils.parseRadix16Byte(array[i]) * 16 + ByteUtils.parseRadix16Byte(array[i + 1]));
            i += 2;
            ++j;
        }
    }

    public static String toRadix16(byte[] source, int srcOffset, int len) {
        char[] hex = new char[len * 2];
        for (int j = 0; j < len; ++j) {
            int b = source[j + srcOffset] & 0xFF;
            hex[j * 2] = HEX.charAt(b >>> 4);
            hex[j * 2 + 1] = HEX.charAt(b & 0xF);
        }
        return new String(hex);
    }

    private static int parseRadix16Byte(byte b) {
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 65 && b <= 70) {
            return b - 55;
        }
        if (b >= 97 && b <= 102) {
            return b - 87;
        }
        throw new IllegalArgumentException("Invalid hexadecimal character " + (char)b);
    }

    public static int copy(byte[] src, int srcOffset, byte[] dest, int destOffset, int len) {
        int srcLimit = srcOffset + len;
        int i = srcOffset;
        int j = destOffset;
        while (i < srcLimit) {
            dest[j] = src[i];
            ++i;
            ++j;
        }
        return len;
    }

    public static int asIntValue(byte[] value) {
        return ByteUtils.asIntValue(value, 0);
    }

    public static long asLongValue(byte[] value) {
        return ByteUtils.asLongValue(value, 0);
    }

    public static int asIntValue(byte[] value, int offset) {
        return (value[offset + 0] << 24) + ((value[offset + 1] & 0xFF) << 16) + ((value[offset + 2] & 0xFF) << 8) + ((value[offset + 3] & 0xFF) << 0);
    }

    public static int readIntValue(InputStream in) throws IOException {
        return (in.read() << 24) + ((in.read() & 0xFF) << 16) + ((in.read() & 0xFF) << 8) + (in.read() & 0xFF);
    }

    public static long asLongValue(byte[] value, int o) {
        return ((long)value[o + 0] << 56) + (((long)value[o + 1] & 0xFFL) << 48) + (((long)value[o + 2] & 0xFFL) << 40) + (((long)value[o + 3] & 0xFFL) << 32) + (((long)value[o + 4] & 0xFFL) << 24) + (((long)value[o + 5] & 0xFFL) << 16) + (((long)value[o + 6] & 0xFFL) << 8) + (((long)value[o + 7] & 0xFFL) << 0);
    }

    public static byte[] intValue(int value) {
        byte[] result = new byte[4];
        return ByteUtils.putIntValue(value, result, 0);
    }

    public static byte[] putIntValue(int value, byte[] result, int offset) {
        result[offset + 0] = (byte)(value >>> 24 & 0xFF);
        result[offset + 1] = (byte)(value >>> 16 & 0xFF);
        result[offset + 2] = (byte)(value >>> 8 & 0xFF);
        result[offset + 3] = (byte)(value >>> 0 & 0xFF);
        return result;
    }

    public static void writeIntValue(int value, OutputStream out) throws IOException {
        out.write(value >>> 24 & 0xFF);
        out.write(value >>> 16 & 0xFF);
        out.write(value >>> 8 & 0xFF);
        out.write(value >>> 0 & 0xFF);
    }

    public static void writeLongValue(long value, OutputStream out) throws IOException {
        out.write((byte)(value >>> 56 & 0xFFL));
        out.write((byte)(value >>> 48 & 0xFFL));
        out.write((byte)(value >>> 40 & 0xFFL));
        out.write((byte)(value >>> 32 & 0xFFL));
        out.write((byte)(value >>> 24 & 0xFFL));
        out.write((byte)(value >>> 16 & 0xFFL));
        out.write((byte)(value >>> 8 & 0xFFL));
        out.write((byte)(value >>> 0 & 0xFFL));
    }

    public static byte[] longValue(long value) {
        byte[] result = new byte[8];
        return ByteUtils.putLongValue(value, result, 0);
    }

    public static byte[] putLongValue(long value, byte[] result, int offset) {
        result[offset + 0] = (byte)(value >>> 56 & 0xFFL);
        result[offset + 1] = (byte)(value >>> 48 & 0xFFL);
        result[offset + 2] = (byte)(value >>> 40 & 0xFFL);
        result[offset + 3] = (byte)(value >>> 32 & 0xFFL);
        result[offset + 4] = (byte)(value >>> 24 & 0xFFL);
        result[offset + 5] = (byte)(value >>> 16 & 0xFFL);
        result[offset + 6] = (byte)(value >>> 8 & 0xFFL);
        result[offset + 7] = (byte)(value >>> 0 & 0xFFL);
        return result;
    }

    public static boolean equals(byte[] a, byte[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static final byte[] max(byte[] lArray, byte[] rArray) {
        int cmp = ByteUtils.compare(lArray, 0, lArray.length, rArray, 0, rArray.length);
        if (cmp >= 0) {
            return lArray;
        }
        return rArray;
    }

    public static final boolean equals(byte[] lArray, int leftOffset, int lSize, byte[] rArray, int rightOffset, int rSize) {
        if (lSize != rSize) {
            return false;
        }
        return ByteUtils.compare(lArray, leftOffset, lSize, rArray, rightOffset, rSize) == 0;
    }

    public static final int compare(byte[] lArray, int leftOffset, int lSize, byte[] rArray, int rightOffset, int rSize) {
        int i = leftOffset;
        int j = rightOffset;
        int n = lSize;
        int k = 0;
        while (k < n) {
            if (k >= rSize) {
                return 1;
            }
            int cmp = (lArray[i] & 0xFF) - (rArray[j] & 0xFF);
            if (cmp != 0) {
                return cmp;
            }
            ++k;
            ++i;
            ++j;
        }
        if (lSize < rSize) {
            return -1;
        }
        return 0;
    }

    public static final boolean contains(byte[] cArray, int cOffset, int cSize, byte[] vArray, int vOffset, int vSize) {
        if (cSize == 0 || vSize == 0 || vSize > cSize) {
            return false;
        }
        int cLimit = cOffset + cSize - 1;
        int vLimit = vOffset + vSize - 1;
        int v = vOffset;
        for (int c = cOffset; c <= cLimit; ++c) {
            if (vArray[v] != cArray[c]) {
                v = vOffset;
                if (c + vSize <= cLimit) continue;
                return false;
            }
            if (++v < vLimit) continue;
            return true;
        }
        return false;
    }

    public static final boolean startsWith(byte[] cArray, byte[] vArray) {
        if (cArray.length < vArray.length) {
            return false;
        }
        int cLimit = vArray.length - 1;
        for (int c = 0; c <= cLimit; ++c) {
            if (vArray[c] == cArray[c]) continue;
            return false;
        }
        return true;
    }

    public static final boolean startsWith(ByteBuffer cBuf, ByteBuffer vBuf) {
        if (cBuf.limit() < vBuf.limit()) {
            return false;
        }
        int cLimit = vBuf.limit() - 1;
        for (int c = 0; c <= cLimit; ++c) {
            if (vBuf.get(vBuf.position() + c) == cBuf.get(cBuf.position() + c)) continue;
            return false;
        }
        return true;
    }

    public static int crc32(byte[] array, int offset, int size) {
        int crc = 65535;
        for (int pos = offset; pos < offset + size; ++pos) {
            crc ^= array[pos];
            for (int i = 8; i != 0; --i) {
                if ((crc & 1) != 0) {
                    crc >>= 1;
                    crc ^= 0xA001;
                    continue;
                }
                crc >>= 1;
            }
        }
        return crc;
    }

    public static int sum(byte[] array, int offset, int size) {
        int sum = 0;
        for (int i = offset; i < offset + size; ++i) {
            sum ^= array[i];
        }
        return sum;
    }

    public static byte[] uuid(UUID uuid) {
        byte[] result = new byte[16];
        ByteUtils.putLongValue(uuid.getMostSignificantBits(), result, 0);
        ByteUtils.putLongValue(uuid.getLeastSignificantBits(), result, 8);
        return result;
    }

    public static UUID uuid(byte[] uuid) {
        return new UUID(ByteUtils.asLongValue(uuid, 0), ByteUtils.asLongValue(uuid, 8));
    }

    public static byte[] parseUUID(String uuid) {
        return ByteUtils.parseUUID(uuid, new byte[16], 0);
    }

    public static byte[] parseUUID(String uuid, byte[] dest, int destOffset) {
        ByteUtils.parseUUID(uuid.getBytes(), 1, 0, dest, destOffset);
        return dest;
    }

    public static byte[] parseUUIDNoSpacing(String uuid) {
        byte[] result = new byte[16];
        ByteUtils.parseUUID(uuid.getBytes(), 0, 0, result, 0);
        return result;
    }

    public static byte[] parseUUIDNoSpacing(String uuid, byte[] dest, int destOffset) {
        ByteUtils.parseUUID(uuid.getBytes(), 0, 0, dest, destOffset);
        return dest;
    }

    private static void parseUUID(byte[] uuid, int spacing, int uuidOffset, byte[] dest, int destOffset) {
        long mostSigBits = ByteUtils.parseLongRadix16(uuid, uuidOffset, uuidOffset + 7);
        mostSigBits <<= 16;
        mostSigBits |= ByteUtils.parseLongRadix16(uuid, uuidOffset + 8 + 1 * spacing, uuidOffset + 11 + 1 * spacing);
        mostSigBits <<= 16;
        long leastSigBits = ByteUtils.parseLongRadix16(uuid, uuidOffset + 16 + 3 * spacing, uuidOffset + 19 + 3 * spacing);
        leastSigBits <<= 48;
        ByteUtils.putLongValue(mostSigBits |= ByteUtils.parseLongRadix16(uuid, uuidOffset + 12 + 2 * spacing, uuidOffset + 15 + 2 * spacing), dest, destOffset);
        ByteUtils.putLongValue(leastSigBits |= ByteUtils.parseLongRadix16(uuid, uuidOffset + 20 + 4 * spacing, uuidOffset + 31 + 4 * spacing), dest, destOffset + 8);
    }

    public static String UUIDToString(byte[] src, int offset) {
        return ByteUtils.UUIDToString(ByteUtils.asLongValue(src, offset), ByteUtils.asLongValue(src, offset + 8), "-");
    }

    public static String UUIDToNumericString(byte[] src, int offset) {
        return ByteUtils.UUIDToString(ByteUtils.asLongValue(src, offset), ByteUtils.asLongValue(src, offset + 8), "");
    }

    private static String UUIDToString(long mostSigBits, long leastSigBits, String separator) {
        return ByteUtils.digits(mostSigBits >> 32, 8) + separator + ByteUtils.digits(mostSigBits >> 16, 4) + separator + ByteUtils.digits(mostSigBits, 4) + separator + ByteUtils.digits(leastSigBits >> 48, 4) + separator + ByteUtils.digits(leastSigBits, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static int murmur2(byte[] data) {
        int length = data.length;
        int seed = -1756908916;
        int m = 1540483477;
        int r = 24;
        int h = seed ^ length;
        int length4 = length / 4;
        for (int i = 0; i < length4; ++i) {
            int i4 = i * 4;
            int k = (data[i4 + 0] & 0xFF) + ((data[i4 + 1] & 0xFF) << 8) + ((data[i4 + 2] & 0xFF) << 16) + ((data[i4 + 3] & 0xFF) << 24);
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
        }
        switch (length % 4) {
            case 3: {
                h ^= (data[(length & 0xFFFFFFFC) + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (data[(length & 0xFFFFFFFC) + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= data[length & 0xFFFFFFFC] & 0xFF;
                h *= 1540483477;
            }
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return h;
    }
}

