/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.storage;

import io.amient.affinity.core.storage.MemStore;
import io.amient.affinity.core.storage.StateConf;
import io.amient.affinity.core.util.CloseableIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class MemStoreSimpleMap
extends MemStore {
    private final ConcurrentHashMap<ByteBuffer, ByteBuffer> internal = new ConcurrentHashMap();

    public MemStoreSimpleMap(StateConf conf) throws IOException {
        super(conf);
    }

    @Override
    protected boolean isPersistent() {
        return false;
    }

    @Override
    public CloseableIterator<Map.Entry<ByteBuffer, ByteBuffer>> iterator(ByteBuffer prefix) {
        if (prefix != null) {
            throw new UnsupportedOperationException("MemStoreSimpleMap doesn't support prefixes, use MemStoreSortedMap instead");
        }
        return CloseableIterator.apply(this.internal.entrySet().iterator());
    }

    @Override
    public Optional<ByteBuffer> apply(ByteBuffer key) {
        return Optional.ofNullable(this.internal.get(key));
    }

    @Override
    public long numKeys() {
        return this.internal.size();
    }

    @Override
    public void put(ByteBuffer key, ByteBuffer value) {
        this.internal.put(key, value);
    }

    @Override
    public void remove(ByteBuffer key) {
        this.internal.remove(key);
    }

    @Override
    public void close() throws IOException {
        this.internal.clear();
    }
}

