/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.util;

import io.amient.affinity.core.util.EventTime;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.Period;

public class TimeRange
implements Serializable {
    static final long serialVersionUID = 1L;
    public final long start;
    public final long end;
    public final long duration;
    private static final Long UNBOUNDED_MIN_TIME = 0L;
    private static final Long UNBOUNDED_MAX_TIME = Long.MAX_VALUE;
    public static final TimeRange UNBOUNDED = new TimeRange(UNBOUNDED_MIN_TIME, UNBOUNDED_MAX_TIME);

    public String toString() {
        String from = this.start == UNBOUNDED_MIN_TIME ? "\u221e" : this.getLocalStart().toString();
        String to = this.end == UNBOUNDED_MAX_TIME ? "\u221e" : this.getLocalEnd().toString();
        return from + " .. " + to;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TimeRange)) {
            return false;
        }
        TimeRange o = (TimeRange)other;
        return o.start == this.start && o.end == this.end;
    }

    public Duration getDuration() {
        return Duration.ofMillis(this.duration);
    }

    public OffsetDateTime getLocalStart() {
        return EventTime.local(this.start);
    }

    public OffsetDateTime getLocalEnd() {
        return EventTime.local(this.end);
    }

    public boolean contains(long unixtimestamp) {
        return unixtimestamp >= this.start && unixtimestamp < this.end;
    }

    public boolean contains(OffsetDateTime datetime) {
        return this.contains(datetime.toInstant().toEpochMilli());
    }

    public static TimeRange since(OffsetDateTime datetime) {
        return TimeRange.since(datetime.toInstant().toEpochMilli());
    }

    public static TimeRange since(String dt) {
        return TimeRange.since(EventTime.unix(dt));
    }

    public static TimeRange since(long unixtimestamp) {
        return new TimeRange(unixtimestamp, UNBOUNDED_MAX_TIME);
    }

    public static TimeRange until(OffsetDateTime datetime) {
        return TimeRange.until(datetime.toInstant().toEpochMilli());
    }

    public static TimeRange until(long unixtimestamp) {
        return new TimeRange(0L, unixtimestamp);
    }

    public static TimeRange prev(Duration length) {
        return TimeRange.prev(length, Instant.ofEpochMilli(EventTime.unix()));
    }

    public static TimeRange prev(Duration length, String beforeDatetime) {
        return TimeRange.prev(length, (Long)EventTime.unix(beforeDatetime));
    }

    public static TimeRange prev(Duration length, Long beforeEpochmillis) {
        return TimeRange.prev(length, Instant.ofEpochMilli(beforeEpochmillis));
    }

    public static TimeRange prev(Duration length, Instant before) {
        return new TimeRange(before.toEpochMilli() - length.toMillis(), before.toEpochMilli());
    }

    public static TimeRange prev(Period length) {
        return TimeRange.prev(length, Instant.ofEpochMilli(EventTime.unix()));
    }

    public static TimeRange prev(Period length, String beforeDateTime) {
        return TimeRange.prev(length, (Long)EventTime.unix(beforeDateTime));
    }

    public static TimeRange prev(Period length, Long beforeEpochMillis) {
        return TimeRange.prev(length, Instant.ofEpochMilli(beforeEpochMillis));
    }

    public static TimeRange prev(Period length, Instant before) {
        return new TimeRange(Instant.from(length.subtractFrom(before)).toEpochMilli(), before.toEpochMilli());
    }

    public static TimeRange next(Duration length) {
        return TimeRange.next(length, Instant.ofEpochMilli(EventTime.unix()));
    }

    public static TimeRange next(Duration length, String afterDatetime) {
        return TimeRange.next(length, (Long)EventTime.unix(afterDatetime));
    }

    public static TimeRange next(Duration length, Long afterEpochMillis) {
        return TimeRange.next(length, Instant.ofEpochMilli(afterEpochMillis));
    }

    public static TimeRange next(Duration length, Instant after) {
        return new TimeRange(after.toEpochMilli(), Instant.from(length.addTo(after)).toEpochMilli());
    }

    public static TimeRange next(Period length) {
        return TimeRange.next(length, Instant.ofEpochMilli(EventTime.unix()));
    }

    public static TimeRange next(Period length, String afterDateTime) {
        return TimeRange.next(length, (Long)EventTime.unix(afterDateTime));
    }

    public static TimeRange next(Period length, Long afterEpochMillis) {
        return TimeRange.next(length, Instant.ofEpochMilli(afterEpochMillis));
    }

    public static TimeRange next(Period length, Instant after) {
        return new TimeRange(after.toEpochMilli(), Instant.from(length.addTo(after)).toEpochMilli());
    }

    public TimeRange(OffsetDateTime start, OffsetDateTime end) {
        this(start.toInstant(), end.toInstant());
    }

    public TimeRange(Instant start, Instant end) {
        this(start.toEpochMilli(), end.toEpochMilli());
    }

    public TimeRange(Duration until, Instant end) {
        this(end.toEpochMilli() - until.toMillis(), end.toEpochMilli());
    }

    public TimeRange(Instant start, Duration length) {
        this(start.toEpochMilli(), start.toEpochMilli() + length.toMillis());
    }

    public TimeRange(Period until, Instant end) {
        this(Instant.from(until.subtractFrom(end)).toEpochMilli(), end.toEpochMilli());
    }

    public TimeRange(String startDt, String endDt) {
        this(EventTime.unix(startDt), EventTime.unix(endDt));
    }

    public TimeRange(long startEpochMs, long endEpochMs) {
        this.start = Math.max(0L, startEpochMs);
        this.end = Math.max(this.start, endEpochMs);
        this.duration = endEpochMs - startEpochMs;
    }
}

