/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.storage;

import io.amient.affinity.core.storage.MemStore;
import io.amient.affinity.core.storage.StateConf;
import io.amient.affinity.core.util.ByteUtils;
import io.amient.affinity.core.util.CloseableIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;

public class MemStoreSortedMap
extends MemStore {
    private final ConcurrentSkipListMap<ByteBuffer, ByteBuffer> internal2 = new ConcurrentSkipListMap();

    public MemStoreSortedMap(StateConf conf) throws IOException {
        super(conf);
    }

    @Override
    protected boolean isPersistent() {
        return false;
    }

    @Override
    public CloseableIterator<Map.Entry<ByteBuffer, ByteBuffer>> iterator(final ByteBuffer prefix) {
        if (prefix == null) {
            return CloseableIterator.apply(this.internal2.entrySet().iterator());
        }
        ByteBuffer startKey = this.internal2.higherKey(prefix);
        if (startKey == null) {
            return CloseableIterator.empty();
        }
        final Iterator tailEntries = this.internal2.tailMap((Object)startKey).entrySet().iterator();
        return new CloseableIterator<Map.Entry<ByteBuffer, ByteBuffer>>(){
            Map.Entry<ByteBuffer, ByteBuffer> head = null;

            @Override
            public void close() throws IOException {
            }

            @Override
            public boolean hasNext() {
                if (this.head == null && tailEntries.hasNext()) {
                    this.head = (Map.Entry)tailEntries.next();
                    if (!ByteUtils.startsWith(this.head.getKey(), prefix)) {
                        this.head = null;
                    }
                }
                return this.head != null;
            }

            @Override
            public Map.Entry<ByteBuffer, ByteBuffer> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry<ByteBuffer, ByteBuffer> result = this.head;
                this.head = null;
                return result;
            }
        };
    }

    @Override
    public Optional<ByteBuffer> apply(ByteBuffer key) {
        return Optional.ofNullable(this.internal2.get(key));
    }

    @Override
    public long numKeys() {
        return this.internal2.size();
    }

    @Override
    public void put(ByteBuffer key, ByteBuffer value) {
        this.internal2.put(key, value);
    }

    @Override
    public void remove(ByteBuffer key) {
        this.internal2.remove(key);
    }

    @Override
    public void close() throws IOException {
        this.internal2.clear();
    }
}

