/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.storage;

import io.amient.affinity.core.config.CfgCls;
import io.amient.affinity.core.config.CfgInt;
import io.amient.affinity.core.config.CfgPath;
import io.amient.affinity.core.config.CfgStruct;
import io.amient.affinity.core.storage.Record;
import io.amient.affinity.core.storage.StateConf;
import io.amient.affinity.core.util.ByteUtils;
import io.amient.affinity.core.util.CloseableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MemStore
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MemStore.class);
    private final boolean checkpointsEnable = this.isPersistent();
    protected final int ttlSecs;
    protected final Path dataDir;

    public MemStore(StateConf conf) throws IOException {
        this.ttlSecs = (Integer)conf.TtlSeconds.apply();
        if (!this.checkpointsEnable) {
            this.dataDir = null;
        } else {
            this.dataDir = (Path)conf.MemStore.DataDir.apply();
            if (!Files.exists(this.dataDir, new LinkOption[0])) {
                Files.createDirectories(this.dataDir, new FileAttribute[0]);
            }
        }
    }

    protected abstract boolean isPersistent();

    public abstract CloseableIterator<Map.Entry<ByteBuffer, ByteBuffer>> iterator(ByteBuffer var1);

    public abstract Optional<ByteBuffer> apply(ByteBuffer var1);

    public abstract long numKeys();

    public abstract void put(ByteBuffer var1, ByteBuffer var2);

    public abstract void remove(ByteBuffer var1);

    public final ByteBuffer wrap(byte[] value, long timestamp) {
        ByteBuffer memStoreValue = ByteBuffer.allocate(8 + value.length);
        memStoreValue.order(ByteOrder.BIG_ENDIAN);
        memStoreValue.putLong(timestamp);
        memStoreValue.put(value);
        memStoreValue.flip();
        return memStoreValue;
    }

    public final Optional<Record<byte[], byte[]>> unwrap(ByteBuffer key, ByteBuffer valueAndMetadata, long ttlMs) {
        long ts = valueAndMetadata.getLong(0);
        if (ttlMs > 0L && valueAndMetadata.getLong(0) + ttlMs < System.currentTimeMillis()) {
            this.remove(key);
            return Optional.empty();
        }
        int len = valueAndMetadata.limit();
        byte[] value = new byte[len - 8];
        valueAndMetadata.position(8);
        valueAndMetadata.get(value);
        return Optional.of(new Record<byte[], byte[]>(ByteUtils.bufToArray(key), value, ts));
    }

    public static class MemStoreConf
    extends CfgStruct<MemStoreConf> {
        public CfgCls<MemStore> Class = this.cls("class", MemStore.class, true);
        public CfgPath DataDir = this.filepath("data.dir", false);
        public CfgInt KeyPrefixSize = this.integer("key.prefix.size", false);

        @Override
        protected Set<String> specializations() {
            return new HashSet<String>(Arrays.asList("mapdb", "rocksdb"));
        }
    }
}

