/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.storage;

import com.typesafe.config.Config;
import io.amient.affinity.core.Murmur2Partitioner;
import io.amient.affinity.core.Partitioner;
import io.amient.affinity.core.config.CfgCls;
import io.amient.affinity.core.config.CfgLong;
import io.amient.affinity.core.config.CfgStruct;
import io.amient.affinity.core.storage.MemStore;
import io.amient.affinity.core.storage.ObservableState;
import io.amient.affinity.core.storage.StateConf;
import io.amient.affinity.stream.Record;
import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Storage
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Storage.class);
    public static StorageConf Conf = new StorageConf(){

        @Override
        public StorageConf apply(Config config) {
            return (StorageConf)new StorageConf().apply(config);
        }
    };
    public final MemStore memstore;
    public final String id;
    public final int partition;
    protected final Partitioner defaultPartitioner = new Murmur2Partitioner();

    public Storage(String id, StateConf conf, int partition) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.partition = partition;
        this.id = id;
        Class memstoreClass = (Class)conf.MemStore.Class.apply();
        Constructor memstoreConstructor = memstoreClass.getConstructor(String.class, StateConf.class);
        this.memstore = (MemStore)memstoreConstructor.newInstance(id, conf);
        this.memstore.open();
    }

    public abstract void init(ObservableState<?> var1);

    public abstract void boot();

    public abstract void tail();

    @Override
    public void close() {
        try {
            this.memstore.close();
        }
        finally {
            log.debug("Closed storage " + this.id + ", partition: " + this.partition);
        }
    }

    public abstract Future<Long> write(Record<byte[], byte[]> var1);

    public abstract Future<Long> delete(byte[] var1);

    public abstract String keySubject();

    public abstract String valueSubject();

    public static class StorageConf
    extends CfgStruct<StorageConf> {
        public CfgCls<Storage> Class = this.cls("class", Storage.class, true);
        public CfgLong MinTimestamp = this.longint("min.timestamp.ms", 0L);

        @Override
        protected Set<String> specializations() {
            return new HashSet<String>(Arrays.asList("kafka"));
        }
    }
}

