/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.storage;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;

public abstract class ObservableState<K>
extends Observable {
    private Map<K, ObservableKeyValue> observables = new HashMap<K, ObservableKeyValue>();

    private ObservableKeyValue getOrCreate(K key) {
        ObservableKeyValue observable = this.observables.get(key);
        if (observable == null) {
            observable = new ObservableKeyValue();
            this.observables.put(key, observable);
        }
        return observable;
    }

    public ObservableKeyValue addKeyValueObserver(K key, Observer observer) {
        ObservableKeyValue observable = this.getOrCreate(key);
        observable.addObserver(observer);
        return observable;
    }

    public Observer addKeyValueObserver(K key, Object initEvent, Observer observer) {
        ObservableKeyValue observable = this.getOrCreate(key);
        observable.addObserver(observer);
        observer.update(observable, initEvent);
        return observer;
    }

    public void removeKeyValueObserver(K key, Observer observer) {
        ObservableKeyValue observable = this.observables.get(key);
        if (observable != null) {
            observable.deleteObserver(observer);
            if (observable.countObservers() == 0) {
                this.observables.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(K key, Object event) {
        try {
            ObservableKeyValue observable = this.observables.get(key);
            if (observable != null) {
                observable.notifyObservers(event);
            }
        }
        finally {
            this.setChanged();
            this.notifyObservers(new AbstractMap.SimpleEntry<K, Object>(key, event));
        }
    }

    public abstract void internalPush(byte[] var1, Optional<byte[]> var2);

    class ObservableKeyValue
    extends Observable {
        ObservableKeyValue() {
        }

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    }
}

